"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.daemon = void 0;
const http = require('http');
const node_fetch_1 = __importDefault(require("node-fetch"));
const errors_1 = require("../bchat/utils/errors");
const daemon_1 = require("../state/ducks/daemon");
class Daemon {
    data_dir;
    wallet_dir;
    auth;
    heartbeat;
    last_height_send_time;
    wallet_state;
    id;
    agent;
    dispatch;
    PIVOT_BLOCK_HEIGHT;
    PIVOT_BLOCK_TIMESTAMP;
    PIVOT_BLOCK_TIME;
    constructor() {
        this.data_dir = null;
        this.wallet_dir = null;
        this.auth = [];
        this.heartbeat = null;
        this.heartbeat = null;
        this.wallet_state = {
            open: false,
            name: '',
            password_hash: null,
            balance: null,
            unlocked_balance: null,
            bnsRecords: [],
        };
        this.last_height_send_time = Date.now();
        this.agent = new http.Agent({ keepAlive: true, maxSockets: 10 });
        this.PIVOT_BLOCK_HEIGHT = window.networkType == 'mainnet' ? 742421 : 169960;
        this.PIVOT_BLOCK_TIMESTAMP = window.networkType == 'mainnet' ? 1639187815 : 1668921922;
        this.PIVOT_BLOCK_TIME = 0;
    }
    daemonHeartbeat() {
        clearInterval(this.heartbeat);
        this.heartbeat = setInterval(() => {
            this.sendRPC('get_info').then(data => {
                if (!data.hasOwnProperty('error')) {
                    window.inboxStore?.dispatch((0, daemon_1.updateDaemon)({ height: data.result.height }));
                }
            });
        }, 3000);
    }
    heartbeatAction() {
        throw new Error('Method not implemented.');
    }
    sendRPC = async (method, params = {}) => {
        try {
            const currentDaemon = window.getSettingValue('current-deamon')
                ? window.getSettingValue('current-deamon')
                : window.currentDaemon;
            const url = `http://${currentDaemon.host}:${currentDaemon.port}/json_rpc`;
            const fetchOptions = {
                method: 'POST',
                body: JSON.stringify({
                    jsonrpc: '2.0',
                    id: '0',
                    method: method,
                    params,
                }),
            };
            const response = await (0, node_fetch_1.default)(url, fetchOptions);
            if (!response.ok) {
                throw new errors_1.HTTPError('beldex_rpc error', response);
            }
            const result = await response.json();
            if (result.hasOwnProperty('error')) {
                return {
                    method: method,
                    params: params,
                    error: result.error,
                };
            }
            return {
                method: method,
                params: params,
                result: result.result,
            };
        }
        catch (e) {
            throw new errors_1.HTTPError('exception during wallet-rpc:', e);
        }
    };
    timestampToHeight(date) {
        return new Promise((resolve, reject) => {
            let timestamp = new Date(date).getTime();
            timestamp = timestamp - (timestamp % 86400000) - 86400000;
            if (timestamp > 999999999999) {
                timestamp = Math.floor(timestamp / 1000);
            }
            if (timestamp > this.PIVOT_BLOCK_TIMESTAMP) {
                this.PIVOT_BLOCK_TIME = 30;
            }
            else {
                this.PIVOT_BLOCK_TIME = 120;
            }
            const pivot = [this.PIVOT_BLOCK_HEIGHT, this.PIVOT_BLOCK_TIMESTAMP];
            let diff = Math.floor((timestamp - pivot[1]) / this.PIVOT_BLOCK_TIME);
            let estimated_height = pivot[0] + diff;
            if (estimated_height <= 0) {
                return resolve(0);
            }
            this.sendRPC('getblockheaderbyheight', {
                height: estimated_height,
            }).then(data => {
                if (data.hasOwnProperty('error') || !data.hasOwnProperty('result')) {
                    if (data.error.code == -2) {
                        this.sendRPC('getlastblockheader').then(data => {
                            if (data.hasOwnProperty('error') || !data.hasOwnProperty('result')) {
                                return reject();
                            }
                            let new_pivot = [data.result.block_header.height, data.result.block_header.timestamp];
                            if (Math.abs(timestamp - new_pivot[1]) < 3600) {
                                return resolve(new_pivot[0]);
                            }
                            resolve(new_pivot[0]);
                        });
                        return;
                    }
                    else {
                        return reject();
                    }
                }
                let new_pivot = [data.result.block_header.height, data.result.block_header.timestamp];
                if (Math.abs(timestamp - new_pivot[1]) < 3600) {
                    return resolve(new_pivot[0]);
                }
                resolve(new_pivot[0]);
            });
        });
    }
}
exports.daemon = new Daemon();
