"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.notifyPnServer = exports.hrefPnServerProd = void 0;
const util_worker_interface_1 = require("../../../webworker/workers/util_worker_interface");
const onionSend_1 = require("../../onions/onionSend");
const pnServerPubkeyHex = '589f8d0d376933e6a48266423235f323dfa4eb4179903314cf5dfb30d6cf794a';
exports.hrefPnServerProd = 'pushnotificationv1.rpcnode.stream';
const pnServerUrl = `http://${exports.hrefPnServerProd}`;
async function notifyPnServer(wrappedEnvelope, sentTo) {
    const options = {
        method: 'post',
        objBody: {
            data: await (0, util_worker_interface_1.callUtilsWorker)('arrayBufferToStringBase64', wrappedEnvelope),
            send_to: sentTo,
        },
    };
    const endpoint = 'notify';
    const ret = await serverRequest(`${pnServerUrl}/${endpoint}`, options);
    if (!ret) {
        window?.log?.warn('Push notification server request returned false');
    }
}
exports.notifyPnServer = notifyPnServer;
const serverRequest = async (endpoint, options) => {
    const { method, objBody } = options;
    const url = new URL(endpoint);
    const fetchOptions = {};
    const headers = {};
    try {
        headers['Content-Type'] = 'application/json';
        fetchOptions.body = JSON.stringify(objBody);
        fetchOptions.headers = headers;
        fetchOptions.method = method;
    }
    catch (e) {
        window?.log?.error('onionSend:::notifyPnServer - set up error:', e.code, e.message);
        return false;
    }
    try {
        const onionResponse = await (0, onionSend_1.sendViaOnionToNonSnode)(pnServerPubkeyHex, url, fetchOptions);
        if (!onionResponse ||
            !onionResponse.result ||
            onionResponse.result.status !== 200) {
            throw new Error(`Failed to do PN notify call, no response, ${onionResponse}`);
        }
    }
    catch (e) {
        window?.log?.error('onionSend:::serverRequest error', e.code, e.message, 'attempting connection to', url.toString());
        return false;
    }
    return true;
};
