"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleHardforkResult = exports.getHasSeenHF180 = exports.getHasSeenHF170 = exports.resetHardForkCachedValues = void 0;
const lodash_1 = require("lodash");
const channelsItem_1 = require("../../../data/channelsItem");
let hasSeenHardfork170;
let hasSeenHardfork180;
function resetHardForkCachedValues() {
    hasSeenHardfork170 = hasSeenHardfork180 = undefined;
}
exports.resetHardForkCachedValues = resetHardForkCachedValues;
async function getHasSeenHF170() {
    if (hasSeenHardfork170 === undefined) {
        const oldHhasSeenHardfork170 = (await (0, channelsItem_1.getItemById)('hasSeenHardfork170'))?.value;
        if (oldHhasSeenHardfork170 === undefined) {
            await (0, channelsItem_1.createOrUpdateItem)({ id: 'hasSeenHardfork170', value: false });
            hasSeenHardfork170 = false;
        }
        else {
            hasSeenHardfork170 = oldHhasSeenHardfork170;
        }
    }
    return hasSeenHardfork170;
}
exports.getHasSeenHF170 = getHasSeenHF170;
async function getHasSeenHF180() {
    if (hasSeenHardfork180 === undefined) {
        const oldHhasSeenHardfork180 = (await (0, channelsItem_1.getItemById)('hasSeenHardfork180'))?.value;
        if (oldHhasSeenHardfork180 === undefined) {
            await (0, channelsItem_1.createOrUpdateItem)({ id: 'hasSeenHardfork180', value: false });
            hasSeenHardfork180 = false;
        }
        else {
            hasSeenHardfork180 = oldHhasSeenHardfork180;
        }
    }
    return hasSeenHardfork180;
}
exports.getHasSeenHF180 = getHasSeenHF180;
async function handleHardforkResult(json) {
    if (hasSeenHardfork170 === undefined || hasSeenHardfork180 === undefined) {
        const oldHhasSeenHardfork170 = (await (0, channelsItem_1.getItemById)('hasSeenHardfork170'))?.value;
        const oldHasSeenHardfork180 = (await (0, channelsItem_1.getItemById)('hasSeenHardfork180'))?.value;
        if (oldHhasSeenHardfork170 === undefined) {
            await (0, channelsItem_1.createOrUpdateItem)({ id: 'hasSeenHardfork170', value: false });
            hasSeenHardfork170 = false;
        }
        else {
            hasSeenHardfork170 = oldHhasSeenHardfork170;
        }
        if (oldHasSeenHardfork180 === undefined) {
            await (0, channelsItem_1.createOrUpdateItem)({ id: 'hasSeenHardfork180', value: false });
            hasSeenHardfork180 = false;
        }
        else {
            hasSeenHardfork180 = oldHasSeenHardfork180;
        }
    }
    if (hasSeenHardfork180 && hasSeenHardfork170) {
        window.log.info('hardfork 18.0 already happened. No need to go any further');
        return;
    }
    if (json?.hf &&
        Array.isArray(json.hf) &&
        json.hf.length === 2 &&
        (0, lodash_1.isNumber)(json.hf[0]) &&
        (0, lodash_1.isNumber)(json.hf[1])) {
        if (!hasSeenHardfork170 && json.hf[0] >= 17 && json.hf[1] >= 0) {
            window.log.info('[HF]: We just detected HF 17.0 on "retrieve"');
            await (0, channelsItem_1.createOrUpdateItem)({ id: 'hasSeenHardfork170', value: true });
            hasSeenHardfork170 = true;
        }
        if (!hasSeenHardfork180 && json.hf[0] >= 18 && json.hf[1] >= 0) {
            window.log.info('[HF]: We just detected HF 18.0 on "retrieve"');
            await (0, channelsItem_1.createOrUpdateItem)({ id: 'hasSeenHardfork180', value: true });
            hasSeenHardfork180 = true;
        }
    }
}
exports.handleHardforkResult = handleHardforkResult;
