"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GroupInvitationMessage = void 0;
const __1 = require("..");
const protobuf_1 = require("../../../../protobuf");
class GroupInvitationMessage extends __1.DataMessage {
    url;
    name;
    constructor(params) {
        super({ timestamp: params.timestamp });
        this.url = params.url;
        this.name = params.name;
    }
    dataProto() {
        const openGroupInvitation = new protobuf_1.SignalService.DataMessage.OpenGroupInvitation({
            url: this.url,
            name: this.name,
        });
        return new protobuf_1.SignalService.DataMessage({
            openGroupInvitation
        });
    }
}
exports.GroupInvitationMessage = GroupInvitationMessage;
