"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SharedContactMessage = void 0;
const __1 = require("..");
const protobuf_1 = require("../../../../protobuf");
class SharedContactMessage extends __1.DataMessage {
    address;
    name;
    constructor(params) {
        super({ timestamp: params.timestamp, identifier: params.identifier });
        this.address = params.address;
        this.name = params.name;
    }
    dataProto() {
        const SharedContact = new protobuf_1.SignalService.DataMessage.SharedContact({
            address: this.address,
            name: this.name,
        });
        return new protobuf_1.SignalService.DataMessage({
            sharedContact: SharedContact
        });
    }
}
exports.SharedContactMessage = SharedContactMessage;
