"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PaymentMessage = void 0;
const __1 = require("..");
const protobuf_1 = require("../../../../protobuf");
class PaymentMessage extends __1.DataMessage {
    amount;
    txnId;
    expireTimer;
    constructor(params) {
        super({ timestamp: params.timestamp, identifier: params.identifier });
        this.amount = params.amount;
        this.txnId = params.txnId;
        this.expireTimer = params.expireTimer;
    }
    dataProto() {
        const Payment = new protobuf_1.SignalService.DataMessage.Payment({
            amount: this.amount,
            txnId: this.txnId,
        });
        return new protobuf_1.SignalService.DataMessage({
            payment: Payment,
            expireTimer: this.expireTimer,
        });
    }
}
exports.PaymentMessage = PaymentMessage;
