"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendViaOnionToNonSnode = exports.getOnionPathForSending = exports.endpointRequiresDecoding = void 0;
const _1 = require(".");
const onions_1 = require("../apis/snode_api/onions");
const lodash_1 = __importStar(require("lodash"));
const constants_1 = require("../constants");
const String_1 = require("../utils/String");
const p_retry_1 = __importDefault(require("p-retry"));
const endpointExceptions = ['/reaction'];
const endpointRequiresDecoding = (url) => {
    for (let i = 0; i < endpointExceptions.length; i++) {
        if (url.includes(endpointExceptions[i])) {
            return decodeURIComponent(url);
        }
    }
    return url;
};
exports.endpointRequiresDecoding = endpointRequiresDecoding;
const buildSendViaOnionPayload = (url, fetchOptions) => {
    let tempHeaders = fetchOptions.headers || {};
    const endpoint = (0, exports.endpointRequiresDecoding)(`${url.pathname.replace(/^\//, '')}${url.search || ''}`);
    const payloadObj = {
        method: fetchOptions.method || 'GET',
        body: fetchOptions.body || '',
        endpoint,
        headers: {},
    };
    if (payloadObj.body &&
        typeof payloadObj.body === 'object' &&
        typeof payloadObj.body.pipe === 'function') {
        const fData = payloadObj.body.getBuffer();
        const fHeaders = payloadObj.body.getHeaders();
        tempHeaders = { ...tempHeaders, ...fHeaders };
        payloadObj.body = {
            fileUpload: fData.toString('base64'),
        };
    }
    payloadObj.headers = tempHeaders;
    return payloadObj;
};
const getOnionPathForSending = async () => {
    let pathNodes = [];
    try {
        pathNodes = await _1.OnionPaths.getOnionPath({});
    }
    catch (e) {
        window?.log?.error(`sendViaOnion - getOnionPath Error ${e.code} ${e.message}`);
    }
    if (!pathNodes?.length) {
        window?.log?.warn('sendViaOnion - failing, no path available');
        return null;
    }
    return pathNodes;
};
exports.getOnionPathForSending = getOnionPathForSending;
const initOptionsWithDefaults = (options) => {
    const defaultFetchBasicOptions = {
        retry: 0,
        noJson: false,
    };
    return lodash_1.default.defaults(options, defaultFetchBasicOptions);
};
const sendViaOnionToNonSnode = async (destinationX25519Key, url, fetchOptions, options = {}, abortSignal) => {
    const castedDestinationX25519Key = typeof destinationX25519Key !== 'string' ? (0, String_1.toHex)(destinationX25519Key) : destinationX25519Key;
    if (!destinationX25519Key || typeof destinationX25519Key !== 'string') {
        window?.log?.error('sendViaOnion - called without a server public key or not a string key');
    }
    const defaultedOptions = initOptionsWithDefaults(options);
    const payloadObj = buildSendViaOnionPayload(url, fetchOptions);
    const forcedHttp = url.protocol === constants_1.PROTOCOLS.HTTP;
    const finalRelayOptions = {
        host: url.hostname,
    };
    if (forcedHttp) {
        finalRelayOptions.protocol = 'http';
    }
    if (forcedHttp) {
        finalRelayOptions.port = url.port ? (0, lodash_1.toNumber)(url.port) : 80;
    }
    let result;
    try {
        result = await (0, p_retry_1.default)(async () => {
            const pathNodes = await (0, exports.getOnionPathForSending)();
            if (!pathNodes) {
                throw new Error('getOnionPathForSending is emtpy');
            }
            return (0, onions_1.sendOnionRequestHandlingSnodeEject)({
                nodePath: pathNodes,
                destX25519Any: castedDestinationX25519Key,
                finalDestOptions: payloadObj,
                finalRelayOptions,
                abortSignal,
            });
        }, {
            retries: 2,
            minTimeout: 500,
            onFailedAttempt: e => {
                window?.log?.warn(`sendViaOnionToNonSnodeRetryable attempt #${e.attemptNumber} failed. ${e.retriesLeft} retries left...`);
            },
        });
    }
    catch (e) {
        window?.log?.warn('sendViaOnionToNonSnodeRetryable failed ', e.message);
        return null;
    }
    if (defaultedOptions.noJson) {
        return {
            result,
            txtResponse: result.body,
            response: result.body,
        };
    }
    let txtResponse = '';
    let { body } = result;
    if (typeof body === 'string') {
        txtResponse = result.body;
        try {
            body = JSON.parse(result.body);
        }
        catch (e) {
            window?.log?.error("sendViaOnion Can't decode JSON body", typeof result.body, result.body);
        }
    }
    if (!txtResponse) {
        txtResponse = JSON.stringify(body);
    }
    return { result, txtResponse, response: body };
};
exports.sendViaOnionToNonSnode = sendViaOnionToNonSnode;
