"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatInboxView = void 0;
const react_1 = __importDefault(require("react"));
const react_redux_1 = require("react-redux");
const LeftPane_1 = require("./leftpane/LeftPane");
const react_2 = require("redux-persist/integration/react");
const redux_persist_1 = require("redux-persist");
const conversations_1 = require("../bchat/conversations");
const utils_1 = require("../bchat/utils");
const call_1 = require("../state/ducks/call");
const conversations_2 = require("../state/ducks/conversations");
const defaultRooms_1 = require("../state/ducks/defaultRooms");
const modalDialog_1 = require("../state/ducks/modalDialog");
const onion_1 = require("../state/ducks/onion");
const search_1 = require("../state/ducks/search");
const section_1 = require("../state/ducks/section");
const stagedAttachments_1 = require("../state/ducks/stagedAttachments");
const theme_1 = require("../state/ducks/theme");
const wallet_1 = require("../state/ducks/wallet");
const userConfig_1 = require("../state/ducks/userConfig");
const util_1 = require("../util");
const BchatMainPanel_1 = require("./BchatMainPanel");
const createStore_1 = require("../state/createStore");
const expiringMessages_1 = require("../util/expiringMessages");
const moment_1 = __importDefault(require("moment"));
const walletSection_1 = require("../state/ducks/walletSection");
const daemon_1 = require("../state/ducks/daemon");
const walletInnerSection_1 = require("../state/ducks/walletInnerSection");
const walletConfig_1 = require("../state/ducks/walletConfig");
const bnsConfig_1 = require("../state/ducks/bnsConfig");
const AudioPlayerContext_1 = require("./basic/AudioPlayerContext");
const callHistory_1 = require("../state/ducks/callHistory");
moment_1.default.locale(window.i18n.getLocale());
class BchatInboxView extends react_1.default.Component {
    store;
    constructor(props) {
        super(props);
        this.state = {
            isInitialLoadComplete: false,
        };
    }
    componentDidMount() {
        this.setupLeftPane();
    }
    render() {
        if (!this.state.isInitialLoadComplete) {
            return null;
        }
        const persistor = (0, redux_persist_1.persistStore)(this.store);
        window.persistStore = persistor;
        return (react_1.default.createElement("div", { className: "inbox index" },
            react_1.default.createElement(react_redux_1.Provider, { store: this.store },
                react_1.default.createElement(react_2.PersistGate, { loading: null, persistor: persistor },
                    react_1.default.createElement(AudioPlayerContext_1.AudioPlayerProvider, null,
                        react_1.default.createElement("div", { className: "gutter" },
                            react_1.default.createElement("div", { className: "network-status-container" }),
                            this.renderLeftPane()),
                        react_1.default.createElement(BchatMainPanel_1.BchatMainPanel, null))))));
    }
    renderLeftPane() {
        return react_1.default.createElement(LeftPane_1.LeftPane, null);
    }
    setupLeftPane() {
        const conversations = (0, conversations_1.getConversationController)()
            .getConversations()
            .map(conversation => conversation.getConversationModelProps());
        const timerOptions = expiringMessages_1.ExpirationTimerOptions.getTimerSecondsWithName();
        const initialState = {
            conversations: {
                ...(0, conversations_2.getEmptyConversationState)(),
                conversationLookup: (0, util_1.makeLookup)(conversations, 'id'),
            },
            user: {
                ourNumber: utils_1.UserUtils.getOurPubKeyStrFromCache(),
            },
            section: section_1.initialSectionState,
            defaultRooms: defaultRooms_1.initialDefaultRoomState,
            search: search_1.initialSearchState,
            theme: theme_1.initialThemeState,
            isVerifyBnsCalled: bnsConfig_1.initialisVerifyBnsCalledState,
            wallet: wallet_1.initialWalletState,
            daemon: daemon_1.initialDaemonState,
            onionPaths: onion_1.initialOnionPathState,
            modals: modalDialog_1.initialModalState,
            userConfig: userConfig_1.initialUserConfigState,
            walletConfig: walletConfig_1.initialWalletConfigState,
            walletFocused: walletSection_1.initialWalletSectionState,
            walletInnerFocused: walletInnerSection_1.initialWalletInnerSectionState,
            timerOptions: {
                timerOptions,
            },
            stagedAttachments: (0, stagedAttachments_1.getEmptyStagedAttachmentsState)(),
            call: call_1.initialCallState,
            callHistory: callHistory_1.initialCallHistoryState
        };
        this.store = (0, createStore_1.createStore)(initialState);
        window.inboxStore = this.store;
        window.openConversationWithMessages = conversations_2.openConversationWithMessages;
        this.setState({ isInitialLoadComplete: true });
    }
}
exports.BchatInboxView = BchatInboxView;
