"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProfileInfo = void 0;
const react_1 = __importDefault(require("react"));
const react_redux_1 = require("react-redux");
const conversations_1 = require("../state/selectors/conversations");
const BchatRightPanel_1 = require("./conversation/BchatRightPanel");
const BchatContactListPanel_1 = require("./conversation/BchatContactListPanel");
const BchatViewContactPanel_1 = require("./conversation/BchatViewContactPanel");
const ProfileInfo = (props) => {
    const isShowing = (0, react_redux_1.useSelector)(conversations_1.isRightPanelShowing) || false;
    const isShare = (0, react_redux_1.useSelector)(conversations_1.isShareContact) || false;
    const selectedConversation = (0, react_redux_1.useSelector)(conversations_1.getSelectedConversation);
    const isShowingViewPanel = (0, react_redux_1.useSelector)(conversations_1.getViewContactPanel);
    if (isShowing && selectedConversation) {
        return react_1.default.createElement(BchatRightPanel_1.BchatRightPanelWithDetails, null);
    }
    if (isShare && selectedConversation) {
        return react_1.default.createElement(BchatContactListPanel_1.BchatContactListPanel, { sendMessage: props.sendMessage });
    }
    if (isShowingViewPanel && selectedConversation) {
        return react_1.default.createElement(BchatViewContactPanel_1.BchatViewContactPanel, { ...isShowingViewPanel });
    }
    return react_1.default.createElement(react_1.default.Fragment, null);
};
exports.ProfileInfo = ProfileInfo;
