"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatScrollButton = void 0;
const react_1 = __importDefault(require("react"));
const react_redux_1 = require("react-redux");
const styled_components_1 = __importDefault(require("styled-components"));
const conversations_1 = require("../state/selectors/conversations");
const icon_1 = require("./icon");
const BchatScrollButtonDiv = styled_components_1.default.div `
  position: absolute;
  z-index: 99;
  right: 26px;
  animation: fadein var(--default-duration);
  bottom: 88px;
`;
const BchatScrollButton = (props) => {
    const show = (0, react_redux_1.useSelector)(conversations_1.getShowScrollButton);
    return (react_1.default.createElement(BchatScrollButtonDiv, null,
        react_1.default.createElement("div", { className: "floated-downArrow " }, show && (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement("div", { className: "floated-downArrow-btn-wrapper", role: "button", onClick: props.onClickScrollBottom },
                react_1.default.createElement(icon_1.BchatIcon, { iconType: "arrow", iconSize: 18, iconColor: "var(--color-downArrow)" })),
            react_1.default.createElement("div", { className: "floated-downArrow-unreadCountBox" }, props.unreadCount))))));
};
exports.BchatScrollButton = BchatScrollButton;
