"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatToastContainer = void 0;
const react_1 = __importDefault(require("react"));
const react_toastify_1 = require("react-toastify");
const styled_components_1 = __importDefault(require("styled-components"));
const icon_1 = require("./icon");
const Flex_1 = require("./basic/Flex");
const BchatToastContainerPrivate = () => {
    return (react_1.default.createElement(WrappedToastContainer, { position: "bottom-right", autoClose: 5000, hideProgressBar: true, newestOnTop: true, closeOnClick: true, rtl: false, pauseOnFocusLoss: false, draggable: false, pauseOnHover: true, transition: react_toastify_1.Slide, limit: 5 }));
};
const CloseButton = ({ closeToast }) => (react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: 'center', alignItems: 'center' },
    react_1.default.createElement(icon_1.BchatIconButton, { iconType: 'xWithCircle', iconSize: 20, onClick: closeToast, style: { height: '31px' } })));
const WrappedToastContainer = ({ className, ...rest }) => (react_1.default.createElement("div", { className: className },
    react_1.default.createElement(react_toastify_1.ToastContainer, { ...rest, closeButton: CloseButton })));
exports.BchatToastContainer = (0, styled_components_1.default)(BchatToastContainerPrivate).attrs({}) `
  .Toastify__toast-container {
  }
  .Toastify__toast {
  }
  .Toastify__toast--error {
  }
  .Toastify__toast--warning {
  }
  .Toastify__toast--success {
  }
  .Toastify__toast-body {
  }
  .Toastify__progress-bar {
  }
`;
