"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DebugLogView = void 0;
const react_1 = __importStar(require("react"));
const styled_components_1 = __importDefault(require("styled-components"));
const logging_1 = require("../util/logging");
const StyledContent = styled_components_1.default.div `
  display: flex;
  flex-direction: column;
  padding: 10px;
  height: 100%;
`;
const DebugLogTextArea = (props) => {
    console.warn('DebugLogTextArea ', props.content);
    return react_1.default.createElement("textarea", { spellCheck: "false", rows: 10, value: props.content, style: { height: '100%' } });
};
const DebugLogButtons = (props) => {
    return (react_1.default.createElement("div", { className: "buttons" },
        react_1.default.createElement("button", { className: "grey submit", onClick: e => {
                e.preventDefault();
                if (props.content.length <= 20) {
                    return;
                }
                window.saveLog(props.content);
                window.closeDebugLog();
            } }, window.i18n('saveLogToDesktop'))));
};
const DebugLogViewAndSave = () => {
    const [content, setContent] = (0, react_1.useState)(window.i18n('loading'));
    (0, react_1.useEffect)(() => {
        const operatingSystemInfo = `Operating System: ${window.getOSRelease()}`;
        const commitHashInfo = window.getCommitHash()
            ? `Commit Hash: ${window.getCommitHash()}`
            : '';
        (0, logging_1.fetch)()
            .then((text) => {
            const debugLogWithSystemInfo = `${operatingSystemInfo} ${commitHashInfo} ${text}`;
            setContent(debugLogWithSystemInfo);
        })
            .catch(console.warn);
    }, []);
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(DebugLogTextArea, { content: content }),
        react_1.default.createElement(DebugLogButtons, { content: content })));
};
const DebugLogView = () => {
    return (react_1.default.createElement(StyledContent, null,
        react_1.default.createElement("div", null,
            react_1.default.createElement("button", { className: "x close", "aria-label": "close debug log", onClick: () => {
                    window.closeDebugLog();
                } }),
            react_1.default.createElement("h1", null,
                " ",
                window.i18n('debugLog'),
                " "),
            react_1.default.createElement("p", null,
                " ",
                window.i18n('debugLogExplanation'))),
        react_1.default.createElement(DebugLogViewAndSave, null)));
};
exports.DebugLogView = DebugLogView;
