"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MainViewController = exports.AddNewContactInEmptyConvo = exports.MessageView = void 0;
const react_1 = __importStar(require("react"));
const utils_1 = require("../bchat/utils");
const closedGroups_1 = require("../receiver/closedGroups");
const constants_1 = require("../bchat/constants");
const SmileSymbolIcon_1 = __importDefault(require("./icon/SmileSymbolIcon"));
const BchatButton_1 = require("./basic/BchatButton");
const Text_1 = require("./basic/Text");
const BchatIdEditable_1 = require("./basic/BchatIdEditable");
const PubKey_1 = require("../bchat/types/PubKey");
const conversations_1 = require("../bchat/conversations");
const conversation_1 = require("../models/conversation");
const conversations_2 = require("../state/ducks/conversations");
const snode_api_1 = require("../bchat/apis/snode_api");
const styled_components_1 = __importDefault(require("styled-components"));
class MessageView extends react_1.default.Component {
    render() {
        return (react_1.default.createElement("div", { className: "conversation placeholder" },
            react_1.default.createElement("div", { className: "conversation-header" }),
            react_1.default.createElement("div", { className: "container" },
                react_1.default.createElement("div", { className: "content bchat-full-logo" },
                    react_1.default.createElement("div", { className: "bchat-text-logo" })))));
    }
}
exports.MessageView = MessageView;
const AddNewContactInEmptyConvo = () => {
    const [bchatId, setBchatId] = (0, react_1.useState)('');
    async function handleMessageButtonClick() {
        const pubkeyorOnsTrimmed = bchatId.trim();
        if (!pubkeyorOnsTrimmed) {
            utils_1.ToastUtils.pushToastError('invalidPubKey', 'Please enter the Id or BNS');
            return;
        }
        if ((!pubkeyorOnsTrimmed || pubkeyorOnsTrimmed.length !== 66) &&
            !pubkeyorOnsTrimmed.toLowerCase().endsWith('.bdx')) {
            utils_1.ToastUtils.pushToastError('invalidPubKey', window.i18n('invalidNumberError'));
            return;
        }
        if (!PubKey_1.PubKey.validateWithError(pubkeyorOnsTrimmed)) {
            await (0, conversations_1.getConversationController)().getOrCreateAndWait(pubkeyorOnsTrimmed, conversation_1.ConversationTypeEnum.PRIVATE);
            await (0, conversations_2.openConversationWithMessages)({ conversationKey: pubkeyorOnsTrimmed, messageId: null });
        }
        else {
            try {
                const resolvedBchatID = await snode_api_1.SNodeAPI.getBchatIDForOnsName(pubkeyorOnsTrimmed);
                if (PubKey_1.PubKey.validateWithError(resolvedBchatID)) {
                    throw new Error('Got a resolved BNS but the returned entry is not a valid bchatID');
                }
                await (0, conversations_1.getConversationController)().getOrCreateAndWait(resolvedBchatID, conversation_1.ConversationTypeEnum.PRIVATE);
                await (0, conversations_2.openConversationWithMessages)({
                    conversationKey: resolvedBchatID,
                    messageId: null,
                    bns: pubkeyorOnsTrimmed,
                });
            }
            catch (e) {
                window?.log?.warn('failed to resolve bns name', pubkeyorOnsTrimmed, e);
                utils_1.ToastUtils.pushToastError('invalidPubKey', window.i18n('failedResolveOns'));
            }
            finally {
            }
        }
    }
    return (react_1.default.createElement("div", { className: "conversation placeholder" },
        react_1.default.createElement("div", { className: "conversation-header" }),
        react_1.default.createElement("div", { className: "container" },
            react_1.default.createElement("div", { className: "content bchat-full-logo" },
                react_1.default.createElement("div", { className: "bchat-text-logo" }),
                react_1.default.createElement(StartConvoWrapper, null,
                    react_1.default.createElement("div", { className: "bchat-text" },
                        window.i18n('startConversation'),
                        " ",
                        react_1.default.createElement(SmileSymbolIcon_1.default, null)),
                    react_1.default.createElement(Text_1.SpacerLG, null),
                    react_1.default.createElement("div", null,
                        react_1.default.createElement(BchatIdEditable_1.BchatIdEditable, { editable: true, placeholder: 'Enter BChat ID or BNS', value: bchatId, isGroup: false, maxLength: 66, onChange: setBchatId, dataTestId: "new-closed-group-name" })),
                    react_1.default.createElement(Text_1.SpacerLG, null),
                    react_1.default.createElement("div", null,
                        react_1.default.createElement(BchatButton_1.BchatButton, { text: 'Let’s Bchat', buttonType: BchatButton_1.BchatButtonType.Default, buttonColor: BchatButton_1.BchatButtonColor.Primary, onClick: () => handleMessageButtonClick() })))))));
};
exports.AddNewContactInEmptyConvo = AddNewContactInEmptyConvo;
const StartConvoWrapper = styled_components_1.default.div `
width: 24vw;
max-width: 470px;
// margin-left: 43px;
margin-left: 100px;
  
`;
async function createClosedGroup(groupName, groupMemberIds) {
    if (groupName.length === 0) {
        utils_1.ToastUtils.pushToastError('invalidGroupName', window.i18n('invalidGroupNameTooShort'));
        return false;
    }
    else if (groupName.length > constants_1.VALIDATION.MAX_GROUP_NAME_LENGTH) {
        utils_1.ToastUtils.pushToastError('invalidGroupName', window.i18n('invalidGroupNameTooLong'));
        return false;
    }
    if (groupMemberIds.length < 1) {
        utils_1.ToastUtils.pushToastError('pickSecretGroupMember', window.i18n('pickSecretGroupMember'));
        return false;
    }
    else if (groupMemberIds.length >= constants_1.VALIDATION.CLOSED_GROUP_SIZE_LIMIT) {
        utils_1.ToastUtils.pushToastError('secretGroupMaxSize', window.i18n('secretGroupMaxSize'));
        return false;
    }
    await (0, closedGroups_1.createClosedGroup)(groupName, groupMemberIds);
    return true;
}
exports.MainViewController = {
    createClosedGroup,
};
