"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MemberListItem = void 0;
const react_1 = __importDefault(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const Avatar_1 = require("./avatar/Avatar");
const useParamSelector_1 = require("../hooks/useParamSelector");
const CheckBoxTickIcon_1 = __importDefault(require("./icon/CheckBoxTickIcon"));
const icon_1 = require("./icon");
const MemberListItem = (props) => {
    const { isSelected, pubkey, isZombie, isAdmin, onSelect, onUnselect, disableBg, dataTestId, onlyList, removeMem } = props;
    const memberName = (0, useParamSelector_1.useConversationUsernameOrShorten)(pubkey);
    const isBnsHolder = (0, useParamSelector_1.useConversationBnsHolder)(pubkey);
    const validateMemberName = (memberName) => {
        if (memberName?.length == 66) {
            let staringTwoString = memberName.substring(0, 2);
            let lastString = memberName.substring(58, 66);
            return `(${staringTwoString}...${lastString})`;
        }
        return memberName;
    };
    const selectionValidation = removeMem ? !onlyList && !isSelected : !onlyList && isSelected;
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)('bchat-member-item', selectionValidation && 'selected', isZombie && 'zombie', disableBg && 'compact'), onClick: () => {
            !onlyList && (isSelected ? onUnselect?.(pubkey) : onSelect?.(pubkey));
        }, style: !disableBg ? {} : {}, role: "button", "data-testid": dataTestId },
        react_1.default.createElement("div", { className: "bchat-member-item__info", style: { width: '100%' } },
            react_1.default.createElement("span", { className: "bchat-member-item__avatar" },
                react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.M, pubkey: pubkey, isBnsHolder: isBnsHolder })),
            react_1.default.createElement("span", { className: "bchat-member-item__name", style: { marginInlineEnd: '5px', marginBottom: '15px' } }, validateMemberName(memberName))),
        !onlyList && !isAdmin && (react_1.default.createElement("span", { className: (0, classnames_1.default)('bchat-member-item__checkmark', selectionValidation && 'selected') }, selectionValidation ? (react_1.default.createElement(CheckBoxTickIcon_1.default, { iconSize: 26 })) : (react_1.default.createElement(icon_1.BchatIcon, { iconType: 'checkBox', clipRule: "evenodd", fillRule: "evenodd", iconSize: 26 })))),
        isAdmin && react_1.default.createElement("span", { className: "bchat-member-item_admin-txt" }, "Admin")));
};
exports.MemberListItem = MemberListItem;
