"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AudioPlayerProvider = exports.useAudioPlayer = void 0;
const react_1 = __importStar(require("react"));
const react_h5_audio_player_1 = __importDefault(require("react-h5-audio-player"));
const AudioPlayerContext = (0, react_1.createContext)(undefined);
const useAudioPlayer = () => {
    const ctx = (0, react_1.useContext)(AudioPlayerContext);
    if (!ctx)
        throw new Error("useAudioPlayer must be used inside AudioPlayerProvider");
    return ctx;
};
exports.useAudioPlayer = useAudioPlayer;
let onResetCurrentAudio;
const AudioPlayerProvider = ({ children }) => {
    const audioRef = (0, react_1.useRef)(null);
    const [currentPlayingId, setCurrentPlayingId] = (0, react_1.useState)(null);
    const playAudio = (id, src, resetCurrentAudio) => {
        if (audioRef.current?.audio?.current) {
            const audioEl = audioRef.current.audio.current;
            if (audioEl.src !== src) {
                if (onResetCurrentAudio) {
                    onResetCurrentAudio();
                }
                audioEl.src = src;
            }
            onResetCurrentAudio = resetCurrentAudio;
            setCurrentPlayingId(id);
            audioEl.play().catch(console.error);
        }
    };
    const pauseAudio = () => {
        audioRef.current?.audio?.current?.pause();
    };
    const seekTo = (time) => {
        if (audioRef.current?.audio?.current) {
            audioRef.current.audio.current.currentTime = time;
        }
    };
    const handleAudioEnded = () => {
        if (audioRef.current?.audio?.current) {
            const audioEl = audioRef.current.audio.current;
            audioEl.src = '';
            audioEl.remove();
            audioEl.srcObject = null;
        }
        setCurrentPlayingId(null);
    };
    return (react_1.default.createElement(AudioPlayerContext.Provider, { value: { playAudio, pauseAudio, seekTo, currentPlayingId, audioRef, handleAudioEnded } },
        children,
        react_1.default.createElement(react_h5_audio_player_1.default, { ref: audioRef, autoPlayAfterSrcChange: false, autoPlay: false, showJumpControls: false, customAdditionalControls: [], customVolumeControls: [], preload: "metadata", onEnded: () => handleAudioEnded() })));
};
exports.AudioPlayerProvider = AudioPlayerProvider;
