"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatIdEditable = void 0;
const react_1 = __importStar(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const useFocusMount_1 = require("../../hooks/useFocusMount");
const BchatIdEditable = (props) => {
    const { placeholder, onPressEnter, onChange, editable, text, value, maxLength, isGroup, dataTestId, } = props;
    const inputRef = (0, react_1.useRef)(null);
    (0, useFocusMount_1.useFocusMount)(inputRef, editable);
    function handleChange(e) {
        if (editable && onChange) {
            const eventValue = e.target.value?.replace(/(\r\n|\n|\r)/gm, '');
            onChange(eventValue);
        }
    }
    function handleKeyDown(e) {
        if (editable && e.key === 'Enter') {
            e.preventDefault();
            onPressEnter && onPressEnter();
        }
    }
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)('bchat-id-editable', !editable && 'bchat-id-editable-disabled') },
        react_1.default.createElement("textarea", { className: (0, classnames_1.default)(isGroup ? 'group-id-editable-textarea' : 'bchat-id-editable-textarea'), ref: inputRef, placeholder: placeholder, disabled: !editable, spellCheck: false, onKeyDown: handleKeyDown, onChange: handleChange, onBlur: handleChange, value: value || text, maxLength: maxLength, "data-testid": dataTestId })));
};
exports.BchatIdEditable = BchatIdEditable;
