"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatInput = void 0;
const react_1 = __importStar(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const icon_1 = require("../icon");
const LabelItem = (props) => {
    return (react_1.default.createElement("label", { htmlFor: "bchat-input-floating-label", className: (0, classnames_1.default)(props.inputValue !== ''
            ? 'bchat-input-with-label-container filled'
            : 'bchat-input-with-label-container') }, props.label));
};
const ErrorItem = (props) => {
    return (react_1.default.createElement("label", { htmlFor: "bchat-input-floating-label", className: (0, classnames_1.default)('bchat-input-with-label-container filled error') }, props.error));
};
const ShowHideButton = (props) => {
    return react_1.default.createElement(icon_1.BchatIconButton, { iconType: !props.forceShow ? "eye" : 'eye_closed', iconSize: "medium", fillRule: "evenodd", clipRule: "evenodd", onClick: props.toggleForceShow });
};
const BchatInput = (props) => {
    const { autoFocus, placeholder, type, value, maxLength, minLength, enableShowHide, error, label, onValueChanged, inputDataTestId, max, min } = props;
    const [inputValue, setInputValue] = (0, react_1.useState)('');
    const [forceShow, setForceShow] = (0, react_1.useState)(false);
    const correctType = forceShow ? 'text' : type;
    const updateInputValue = (e) => {
        e.preventDefault();
        const val = e.target.value;
        setInputValue(val);
        if (onValueChanged) {
            onValueChanged(val);
        }
    };
    return (react_1.default.createElement("div", { className: "bchat-input-with-label-container" },
        error && (react_1.default.createElement(ErrorItem, { error: props.error })),
        label && (react_1.default.createElement(LabelItem, { inputValue: inputValue, label: label })),
        react_1.default.createElement("input", { id: "bchat-input-floating-label", type: correctType, placeholder: placeholder, value: value, maxLength: maxLength, minLength: minLength, autoFocus: autoFocus, "data-testid": inputDataTestId, max: max, min: min, onChange: updateInputValue, className: (0, classnames_1.default)(enableShowHide ? 'bchat-input-floating-label-show-hide' : ''), onBlur: updateInputValue, onKeyPress: event => {
                if (event.key === 'Enter' && props.onEnterPressed) {
                    props.onEnterPressed();
                }
            } }),
        enableShowHide && (react_1.default.createElement(ShowHideButton, { toggleForceShow: () => {
                setForceShow(!forceShow);
            }, forceShow: forceShow }))));
};
exports.BchatInput = BchatInput;
