"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageBodyHighlight = void 0;
const react_1 = __importDefault(require("react"));
const styled_components_1 = __importDefault(require("styled-components"));
const AddNewLines_1 = require("../conversation/AddNewLines");
const Emojify_1 = require("../conversation/Emojify");
const MessageBody_1 = require("../conversation/message/message-content/MessageBody");
const renderNewLines = ({ text, key, isGroup }) => (react_1.default.createElement(AddNewLines_1.AddNewLines, { key: key, text: text, renderNonNewLine: MessageBody_1.renderTextDefault, isGroup: isGroup }));
const SnippetHighlight = styled_components_1.default.span `
  font-weight: bold;
  color: var(--color-text);
`;
const renderEmoji = ({ text, key, sizeClass, renderNonEmoji, isGroup, }) => (react_1.default.createElement(Emojify_1.Emojify, { key: key, text: text, sizeClass: sizeClass, renderNonEmoji: renderNonEmoji, isGroup: isGroup }));
const MessageBodyHighlight = (props) => {
    const { text, isGroup } = props;
    const results = [];
    const FIND_BEGIN_END = /<<left>>(.+?)<<right>>/g;
    let match = FIND_BEGIN_END.exec(text);
    let last = 0;
    let count = 1;
    if (!match) {
        return (react_1.default.createElement(MessageBody_1.MessageBody, { disableJumbomoji: true, disableLinks: true, text: text, isGroup: isGroup }));
    }
    const sizeClass = 'default';
    while (match) {
        if (last < match.index) {
            const beforeText = text.slice(last, match.index);
            results.push(renderEmoji({
                text: beforeText,
                sizeClass,
                key: count++,
                renderNonEmoji: renderNewLines,
                isGroup,
            }));
        }
        const [, toHighlight] = match;
        results.push(react_1.default.createElement(SnippetHighlight, { key: count++ }, renderEmoji({
            text: toHighlight,
            sizeClass,
            key: count++,
            renderNonEmoji: renderNewLines,
            isGroup,
        })));
        last = FIND_BEGIN_END.lastIndex;
        match = FIND_BEGIN_END.exec(text);
    }
    if (last < text.length) {
        results.push(renderEmoji({
            text: text.slice(last),
            sizeClass,
            key: count++,
            renderNonEmoji: renderNewLines,
            isGroup,
        }));
    }
    return react_1.default.createElement(react_1.default.Fragment, null, results);
};
exports.MessageBodyHighlight = MessageBodyHighlight;
