"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.H3 = exports.SpacerXS = exports.SpacerSM = exports.SpacerMD = exports.SpacerLG = exports.Text = void 0;
const react_1 = __importDefault(require("react"));
const styled_components_1 = __importDefault(require("styled-components"));
const StyledDefaultText = styled_components_1.default.div `
  transition: var(--default-duration);
  max-width: ${props => (props.maxWidth ? props.maxWidth : '')};
  padding: ${props => (props.padding ? props.padding : '')};
  text-align: ${props => (props.textAlign ? props.textAlign : '')};
  font-family: var(--font-default);
  color: ${props => (props.subtle ? 'var(--color-text-subtle)' : 'var(--color-text)')};
  white-space: ${props => (props.ellipsisOverflow ? 'nowrap' : null)};
  overflow: ${props => (props.ellipsisOverflow ? 'hidden' : null)};
  text-overflow: ${props => (props.ellipsisOverflow ? 'ellipsis' : null)};
`;
const Text = (props) => {
    return react_1.default.createElement(StyledDefaultText, { ...props }, props.text);
};
exports.Text = Text;
const SpacerStyled = styled_components_1.default.div `
  height: ${props => props.size === 'lg'
    ? 'var(--margins-lg)'
    : props.size === 'md'
        ? 'var(--margins-md)'
        : props.size === 'sm'
            ? 'var(--margins-sm)'
            : 'var(--margins-xs)'};

  width: ${props => props.size === 'lg'
    ? 'var(--margins-lg)'
    : props.size === 'md'
        ? 'var(--margins-md)'
        : props.size === 'sm'
            ? 'var(--margins-sm)'
            : 'var(--margins-xs)'};
`;
const Spacer = (props) => {
    return react_1.default.createElement(SpacerStyled, { ...props });
};
const SpacerLG = () => {
    return react_1.default.createElement(Spacer, { size: "lg" });
};
exports.SpacerLG = SpacerLG;
const SpacerMD = () => {
    return react_1.default.createElement(Spacer, { size: "md" });
};
exports.SpacerMD = SpacerMD;
const SpacerSM = () => {
    return react_1.default.createElement(Spacer, { size: "sm" });
};
exports.SpacerSM = SpacerSM;
const SpacerXS = () => {
    return react_1.default.createElement(Spacer, { size: "xs" });
};
exports.SpacerXS = SpacerXS;
const StyledH3 = styled_components_1.default.div `
  transition: var(--default-duration);
  font-family: var(--font-default);
  font-size: var(--font-size-md);
  font-weight: 700;
`;
const H3 = (props) => react_1.default.createElement(StyledH3, { ...props }, props.text);
exports.H3 = H3;
