"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CallWindowControls = exports.HangUpButton = exports.AudioOutputButton = exports.AudioInputButton = exports.VideoInputButton = void 0;
const icon_1 = require("../icon");
const react_contexify_1 = require("react-contexify");
const call_1 = require("../../state/ducks/call");
const utils_1 = require("../../bchat/utils");
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const call_2 = require("../../state/selectors/call");
const DropDownAndToggleButton_1 = require("../icon/DropDownAndToggleButton");
const styled_components_1 = __importDefault(require("styled-components"));
const Flex_1 = require("../basic/Flex");
const InConversationCallContainer_1 = require("./InConversationCallContainer");
const videoTriggerId = 'video-menu-trigger-id';
const audioTriggerId = 'audio-menu-trigger-id';
const audioOutputTriggerId = 'audio-output-menu-trigger-id';
const VideoInputButton = ({ currentConnectedCameras, localStreamVideoIsMuted, hideArrowIcon = false, isCallModalExpandView }) => {
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(DropDownAndToggleButton_1.DropDownAndToggleButton, { iconType: localStreamVideoIsMuted ? 'callCameraDisabled' : 'callCamera', isMuted: localStreamVideoIsMuted, onMainButtonClick: () => {
                void handleCameraToggle(currentConnectedCameras, localStreamVideoIsMuted);
            }, onArrowClick: e => {
                showVideoInputMenu(currentConnectedCameras, e);
            }, hidePopoverArrow: hideArrowIcon, isCallModalExpandView: isCallModalExpandView }),
        react_1.default.createElement(VideoInputMenu, { triggerId: videoTriggerId, camerasList: currentConnectedCameras })));
};
exports.VideoInputButton = VideoInputButton;
const AudioInputButton = ({ currentConnectedAudioInputs, isAudioMuted, hideArrowIcon = false, isCallModalExpandView }) => {
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(DropDownAndToggleButton_1.DropDownAndToggleButton, { iconType: isAudioMuted ? 'callMicrophoneDisabled' : 'callMicrophone', isMuted: isAudioMuted, onMainButtonClick: () => {
                void handleMicrophoneToggle(currentConnectedAudioInputs, isAudioMuted);
            }, onArrowClick: e => {
                showAudioInputMenu(currentConnectedAudioInputs, e);
            }, hidePopoverArrow: hideArrowIcon, isCallModalExpandView: isCallModalExpandView }),
        react_1.default.createElement(AudioInputMenu, { triggerId: audioTriggerId, audioInputsList: currentConnectedAudioInputs })));
};
exports.AudioInputButton = AudioInputButton;
const AudioOutputButton = ({ currentConnectedAudioOutputs, isAudioOutputMuted, hideArrowIcon = false, isCallModalExpandView }) => {
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(DropDownAndToggleButton_1.DropDownAndToggleButton, { iconType: isAudioOutputMuted ? "callSpeakerDisabled" : "callSpeaker", isMuted: isAudioOutputMuted, onMainButtonClick: () => {
                void handleSpeakerToggle(currentConnectedAudioOutputs, isAudioOutputMuted);
            }, onArrowClick: e => {
                showAudioOutputMenu(currentConnectedAudioOutputs, e);
            }, hidePopoverArrow: hideArrowIcon, isCallModalExpandView: isCallModalExpandView }),
        react_1.default.createElement(AudioOutputMenu, { triggerId: audioOutputTriggerId, audioOutputsList: currentConnectedAudioOutputs })));
};
exports.AudioOutputButton = AudioOutputButton;
const VideoInputMenu = ({ triggerId, camerasList, }) => {
    return (react_1.default.createElement(react_contexify_1.Menu, { id: triggerId, animation: react_contexify_1.animation.fade }, camerasList.map(m => {
        return (react_1.default.createElement(react_contexify_1.Item, { key: m.deviceId, onClick: () => {
                void utils_1.CallManager.selectCameraByDeviceId(m.deviceId);
            } }, m.label.substr(0, 40)));
    })));
};
const AudioInputMenu = ({ triggerId, audioInputsList, }) => {
    return (react_1.default.createElement(react_contexify_1.Menu, { id: triggerId, animation: react_contexify_1.animation.fade }, audioInputsList.map(m => {
        return (react_1.default.createElement(react_contexify_1.Item, { key: m.deviceId, onClick: () => {
                void utils_1.CallManager.selectAudioInputByDeviceId(m.deviceId);
            } }, m.label.substr(0, 40)));
    })));
};
const AudioOutputMenu = ({ triggerId, audioOutputsList, }) => {
    return (react_1.default.createElement(react_contexify_1.Menu, { id: triggerId, animation: react_contexify_1.animation.fade }, audioOutputsList.map(m => {
        return (react_1.default.createElement(react_contexify_1.Item, { key: m.deviceId, onClick: () => {
                void utils_1.CallManager.selectAudioOutputByDeviceId(m.deviceId);
            } }, m.label.substr(0, 40)));
    })));
};
const ShowInFullScreenButton = ({ isFullScreen, isCallModalExpandView }) => {
    const dispatch = (0, react_redux_1.useDispatch)();
    const showInFullScreen = () => {
        if (isFullScreen) {
            dispatch((0, call_1.setFullScreenCall)(false));
        }
        else {
            dispatch((0, call_1.setFullScreenCall)(true));
        }
    };
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement(DropDownAndToggleButton_1.DropDownAndToggleButton, { iconType: isFullScreen ? 'fullScreenCollapse' : 'fullscreen', isMuted: !isFullScreen, onMainButtonClick: () => {
                showInFullScreen();
            }, onArrowClick: () => { }, hidePopoverArrow: true, isCallModalExpandView: isCallModalExpandView })));
};
const HangUpButton = () => {
    const ongoingCallPubkey = (0, react_redux_1.useSelector)(call_2.getHasOngoingCallWithPubkey);
    const handleEndCall = async () => {
        if (ongoingCallPubkey) {
            await utils_1.CallManager.USER_hangup(ongoingCallPubkey);
        }
    };
    return (react_1.default.createElement("div", { className: "hangingBtn", role: "button", style: {
            backgroundColor: '#FC3B3B',
        }, onClick: handleEndCall },
        react_1.default.createElement(icon_1.BchatIcon, { iconSize: 27, iconType: "hangup", clipRule: "evenodd", fillRule: "evenodd" })));
};
exports.HangUpButton = HangUpButton;
const showAudioInputMenu = (currentConnectedAudioInputs, e) => {
    if (currentConnectedAudioInputs.length === 0) {
        utils_1.ToastUtils.pushNoAudioInputFound();
        return;
    }
    react_contexify_1.contextMenu.show({
        id: audioTriggerId,
        event: e,
    });
};
const showAudioOutputMenu = (currentConnectedAudioOutputs, e) => {
    if (currentConnectedAudioOutputs.length === 0) {
        utils_1.ToastUtils.pushNoAudioOutputFound();
        return;
    }
    react_contexify_1.contextMenu.show({
        id: audioOutputTriggerId,
        event: e,
    });
};
const showVideoInputMenu = (currentConnectedCameras, e) => {
    if (currentConnectedCameras.length === 0) {
        utils_1.ToastUtils.pushNoCameraFound();
        return;
    }
    react_contexify_1.contextMenu.show({
        id: videoTriggerId,
        event: e,
    });
};
const handleCameraToggle = async (currentConnectedCameras, localStreamVideoIsMuted) => {
    if (!currentConnectedCameras.length) {
        utils_1.ToastUtils.pushNoCameraFound();
        return;
    }
    if (localStreamVideoIsMuted) {
        await utils_1.CallManager.selectCameraByDeviceId(currentConnectedCameras[0].deviceId);
    }
    else {
        await utils_1.CallManager.selectCameraByDeviceId(utils_1.CallManager.DEVICE_DISABLED_DEVICE_ID);
    }
};
const handleMicrophoneToggle = async (currentConnectedAudioInputs, isAudioMuted) => {
    if (!currentConnectedAudioInputs.length) {
        utils_1.ToastUtils.pushNoAudioInputFound();
        return;
    }
    if (isAudioMuted) {
        await utils_1.CallManager.selectAudioInputByDeviceId(currentConnectedAudioInputs[0].deviceId);
    }
    else {
        await utils_1.CallManager.selectAudioInputByDeviceId(utils_1.CallManager.DEVICE_DISABLED_DEVICE_ID);
    }
};
const handleSpeakerToggle = async (currentConnectedAudioOutputs, isAudioOutputMuted) => {
    if (!currentConnectedAudioOutputs.length) {
        utils_1.ToastUtils.pushNoAudioInputFound();
        return;
    }
    if (isAudioOutputMuted) {
        await utils_1.CallManager.selectAudioOutputByDeviceId(currentConnectedAudioOutputs[0].deviceId);
    }
    else {
        await utils_1.CallManager.selectAudioOutputByDeviceId(utils_1.CallManager.DEVICE_DISABLED_DEVICE_ID);
    }
};
const StyledCallWindowControls = styled_components_1.default.div `
  
  width: ${props => (props.isFullScreen ? '70%' : props.isCallModalExpandView ? 'unset' : '100%')};
  min-width:${props => (props.isCallModalExpandView ? '570px' : '100%')} ;
  max-width:${props => (props.isCallModalExpandView ? '45%' : '100%')} ;
    
  height: 100%;
  padding: 10px 25px;


  display: flex;
  justify-content: space-between;
  align-items:center;

  border-radius: 26px;
  background:${props => (props.isCallModalExpandView || props.isFullScreen ? 'var(--color-received-message-background)' : 'unset')} ;
  margin: auto;

  ${props => props.isFullScreen && `
    max-width:668px;
     min-width:unset;
    `}
  
   opacity: ${props => (props.makeVisible ? 1 : 0)};
`;
const UserNameTxtBold = styled_components_1.default.div `
  font-size: 18px;
  font-weight: 600;
  line-height: normal;
  width: 150px;
  word-break: break-all;
`;
const CallWindowControls = ({ currentConnectedCameras, currentConnectedAudioInputs, currentConnectedAudioOutputs, isAudioMuted, isAudioOutputMuted, remoteStreamVideoIsMuted, localStreamVideoIsMuted, isFullScreen, selectedName, isCallModalExpandView, }) => {
    const [makeVisible, setMakeVisible] = (0, react_1.useState)(true);
    const setMakeVisibleTrue = () => {
        setMakeVisible(true);
    };
    const setMakeVisibleFalse = () => {
        setMakeVisible(false);
    };
    (0, react_1.useEffect)(() => {
        let hideTimer;
        const showAndDelayHide = () => {
            if (!isFullScreen)
                return;
            setMakeVisibleTrue();
            clearTimeout(hideTimer);
            hideTimer = setTimeout(() => {
                setMakeVisibleFalse();
            }, 5000);
        };
        document.addEventListener('mousemove', showAndDelayHide);
        return () => {
            document.removeEventListener('mousemove', showAndDelayHide);
            clearTimeout(hideTimer);
        };
    }, [isFullScreen, setMakeVisibleTrue, setMakeVisibleFalse]);
    return (react_1.default.createElement(StyledCallWindowControls, { makeVisible: makeVisible, isFullScreen: isFullScreen, isCallModalExpandView: isCallModalExpandView },
        react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "column", alignItems: "flex-start", justifyContent: "center" },
            react_1.default.createElement(UserNameTxtBold, null, selectedName),
            react_1.default.createElement(InConversationCallContainer_1.RingingLabel, null),
            react_1.default.createElement(InConversationCallContainer_1.ConnectingLabel, null),
            react_1.default.createElement(InConversationCallContainer_1.DurationLabel, null)),
        react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "row" },
            !remoteStreamVideoIsMuted && react_1.default.createElement(ShowInFullScreenButton, { isFullScreen: isFullScreen, isCallModalExpandView: isCallModalExpandView }),
            react_1.default.createElement(exports.AudioOutputButton, { currentConnectedAudioOutputs: currentConnectedAudioOutputs, isAudioOutputMuted: isAudioOutputMuted, hideArrowIcon: isFullScreen, isCallModalExpandView: isCallModalExpandView }),
            react_1.default.createElement(exports.VideoInputButton, { currentConnectedCameras: currentConnectedCameras, localStreamVideoIsMuted: localStreamVideoIsMuted, hideArrowIcon: isFullScreen, isCallModalExpandView: isCallModalExpandView }),
            react_1.default.createElement(exports.AudioInputButton, { currentConnectedAudioInputs: currentConnectedAudioInputs, isAudioMuted: isAudioMuted, hideArrowIcon: isFullScreen, isCallModalExpandView: isCallModalExpandView })),
        react_1.default.createElement(exports.HangUpButton, null)));
};
exports.CallWindowControls = CallWindowControls;
