"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DraggableCallContainer = exports.StyledVideoElement = exports.DraggableCallWindow = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const react_draggable_1 = __importDefault(require("react-draggable"));
const styled_components_1 = __importDefault(require("styled-components"));
const conversations_1 = require("../../state/selectors/conversations");
const call_1 = require("../../state/selectors/call");
const conversations_2 = require("../../state/ducks/conversations");
const Avatar_1 = require("../avatar/Avatar");
const useVideoEventListener_1 = require("../../hooks/useVideoEventListener");
const section_1 = require("../../state/selectors/section");
const section_2 = require("../../state/ducks/section");
const InConversationCallContainer_1 = require("./InConversationCallContainer");
const icon_1 = require("../icon");
const modal_1 = require("../../state/selectors/modal");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const lodash_1 = require("lodash");
exports.DraggableCallWindow = styled_components_1.default.div `
  position: absolute;
  z-index: 999;
  box-shadow: 0px 0px 10px 0px #000000;
  max-height: 300px;
  min-width: 8vw;
  max-width: 12vw;
  display: flex;
  flex-direction: column;
  background-color: var(--color-modal-background);
  border: var(--bchat-border);
  overflow: hidden;
  border-radius: 10px;
`;
exports.StyledVideoElement = styled_components_1.default.video `
  // padding: 0 1rem;
  height: ${props => (props.height ? props.height : '100%')};
  width: ${props => (props.width ? props.width : '100%')};
  opacity: ${props => (props.isVideoMuted ? 0 : 1)};
  display: ${props => (props.isVideoMuted ? 'none' : 'block')};
  object-fit: cover;
  border-radius: ${props => (props.isCallModalExpandView ? '30px' : '16px')};
  /*Mirror code starts*/
  transform: rotateY(180deg);
  -webkit-transform: rotateY(180deg); /* Safari and Chrome */
  -moz-transform: rotateY(180deg); /* Firefox */
  /*Mirror code ends*/
`;
const StyledDraggableVideoElement = (0, styled_components_1.default)(exports.StyledVideoElement) `
  padding: 0 0;
`;
const DraggableCallWindowInner = styled_components_1.default.div `
  cursor: pointer;
  min-width: 170px;
  min-height: 85px;
`;
const CenteredAvatarInDraggable = styled_components_1.default.div `
  // position: absolute;
  // width: 100%;
  // top: 0;
  // bottom: 0;
  // left: 0;
  // right: 50%;
  min-height: 85px;
  min-width: 85px;
  display: flex;
  justify-content: center;
  align-items: center;
  padding-top: 20px;
`;
const StyledDurationLabel = styled_components_1.default.div `
  position: ${props => (props.remoteStreamVideoIsMuted ? 'unset' : 'absolute')};
  bottom: 0;
  padding: 5px 10px;
  z-index: 99;
`;
const StyledCloseIcon = styled_components_1.default.div `
  position: absolute;
  top: 5px;
  right: 5px;
  z-index: 99;
  display: flex;
  flex-direction: column;
`;
const StyledLocalVideoContainer = styled_components_1.default.div `
  position: absolute;
  right: ${props => (props.isLocalOnly ? '0' : '5')}px;
  bottom: ${props => (props.isLocalOnly ? '0' : '5')}px;
  width: ${props => (props.isLocalOnly ? '164' : '81')}px;
  height: ${props => (props.isLocalOnly ? '146' : '81')}px;
  overflow: hidden;
  border-radius: 10px;
`;
const DraggableCallContainer = () => {
    const ongoingCallProps = (0, react_redux_1.useSelector)(call_1.getHasOngoingCallWith);
    const selectedConversationKey = (0, react_redux_1.useSelector)(conversations_1.getSelectedConversationKey);
    const hasOngoingCall = (0, react_redux_1.useSelector)(call_1.getHasOngoingCall);
    const BchatWalletPasswordModalState = (0, react_redux_1.useSelector)(modal_1.getBchatWalletPasswordModal);
    const selectedSection = (0, react_redux_1.useSelector)(section_1.getSection);
    const dispatch = (0, react_redux_1.useDispatch)();
    const [positionX, setPositionX] = (0, react_1.useState)(window.innerWidth - (window.innerWidth * 1) / 6);
    const [positionY, setPositionY] = (0, react_1.useState)(90);
    const [lastPositionX, setLastPositionX] = (0, react_1.useState)(0);
    const [lastPositionY, setLastPositionY] = (0, react_1.useState)(0);
    const DRAG_THRESHOLD = 5;
    const ongoingCallPubkey = ongoingCallProps?.id;
    const { remoteStreamVideoIsMuted, remoteStream, localStream, localStreamVideoIsMuted, } = (0, useVideoEventListener_1.useVideoCallEventsListener)('DraggableCallContainer', false);
    const videoRefRemote = (0, react_1.useRef)(null);
    const videoRefLocal = (0, react_1.useRef)(null);
    function onWindowResize() {
        if (positionY + 50 > window.innerHeight || positionX + 50 > window.innerWidth) {
            setPositionX(window.innerWidth / 2);
            setPositionY(window.innerHeight / 2);
        }
    }
    (0, react_1.useEffect)(() => {
        window.addEventListener('resize', onWindowResize);
        return () => {
            window.removeEventListener('resize', onWindowResize);
        };
    }, [positionX, positionY]);
    if (videoRefRemote?.current && remoteStream) {
        if (videoRefRemote.current.srcObject !== remoteStream) {
            videoRefRemote.current.srcObject = remoteStream;
        }
    }
    if (videoRefLocal?.current && localStream) {
        if (videoRefLocal?.current.srcObject !== localStream) {
            videoRefLocal.current.srcObject = localStream;
        }
    }
    (0, react_1.useEffect)(() => {
        if (videoRefRemote?.current && videoRefLocal?.current) {
            videoRefRemote.current.srcObject = remoteStream;
            videoRefLocal.current.srcObject = localStream;
        }
    }, [remoteStreamVideoIsMuted, localStreamVideoIsMuted]);
    const openCallingConversation = () => {
        if (ongoingCallPubkey) {
            if (!(0, lodash_1.isEmpty)(BchatWalletPasswordModalState)) {
                dispatch((0, modalDialog_1.updateBchatWalletPasswordModal)(null));
            }
            dispatch((0, section_2.showLeftPaneSection)(section_2.SectionType.Message));
            dispatch((0, section_2.setOverlayMode)(undefined));
            void (0, conversations_2.openConversationWithMessages)({ conversationKey: ongoingCallPubkey, messageId: null });
        }
    };
    const isDragCallValidation = ongoingCallPubkey === selectedConversationKey;
    if (!hasOngoingCall ||
        !ongoingCallProps ||
        isDragCallValidation &&
            selectedSection.focusedSection !== section_2.SectionType.Settings &&
            selectedSection.focusedSection !== section_2.SectionType.Wallet) {
        return null;
    }
    return (react_1.default.createElement("div", null,
        react_1.default.createElement(react_draggable_1.default, { handle: ".dragHandle", position: { x: positionX, y: positionY }, onStart: (_e, data) => {
                setLastPositionX(data.x);
                setLastPositionY(data.y);
            }, onDrag: (_e, data) => {
                if (Math.abs(data.x - lastPositionX) > DRAG_THRESHOLD ||
                    Math.abs(data.y - lastPositionY) > DRAG_THRESHOLD) {
                }
            }, onStop: (e, data) => {
                e.stopPropagation();
                setPositionX(data.x);
                setPositionY(data.y);
            } },
            react_1.default.createElement(exports.DraggableCallWindow, { className: "dragHandle" },
                react_1.default.createElement(StyledCloseIcon, null,
                    react_1.default.createElement(icon_1.BchatIconButton, { iconType: 'replyArrow', iconSize: 22, btnRadius: "50px", onClick: () => {
                            openCallingConversation();
                        } })),
                react_1.default.createElement(DraggableCallWindowInner, null,
                    react_1.default.createElement(StyledDraggableVideoElement, { ref: videoRefRemote, autoPlay: true, isVideoMuted: remoteStreamVideoIsMuted }),
                    remoteStreamVideoIsMuted && ongoingCallPubkey && (react_1.default.createElement(CenteredAvatarInDraggable, null,
                        react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.XL, pubkey: ongoingCallPubkey })))),
                react_1.default.createElement(StyledLocalVideoContainer, { isLocalOnly: remoteStreamVideoIsMuted },
                    react_1.default.createElement(StyledDraggableVideoElement, { isLocalOnly: remoteStreamVideoIsMuted, ref: videoRefLocal, autoPlay: true, isVideoMuted: localStreamVideoIsMuted })),
                react_1.default.createElement(StyledDurationLabel, { remoteStreamVideoIsMuted: remoteStreamVideoIsMuted },
                    react_1.default.createElement(InConversationCallContainer_1.RingingLabel, { isOutSideInConvo: true }),
                    react_1.default.createElement(InConversationCallContainer_1.DurationLabel, { isDraggable: true, isVideoCall: !remoteStreamVideoIsMuted || !localStreamVideoIsMuted }),
                    react_1.default.createElement(InConversationCallContainer_1.ConnectingLabel, null))))));
};
exports.DraggableCallContainer = DraggableCallContainer;
