"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InConversationCallContainer = exports.VideoLoadingSpinner = exports.DurationLabel = exports.ConnectingLabel = exports.RingingLabel = exports.StyledCenteredLabel = exports.UserNameTxt = exports.CenteredAvatarInConversation = void 0;
const react_redux_1 = require("react-redux");
const react_1 = __importStar(require("react"));
const styled_components_1 = __importDefault(require("styled-components"));
const utils_1 = require("../../bchat/utils");
const call_1 = require("../../state/selectors/call");
const DraggableCallContainer_1 = require("./DraggableCallContainer");
const Avatar_1 = require("../avatar/Avatar");
const useVideoEventListener_1 = require("../../hooks/useVideoEventListener");
const useModuloWithTripleDots_1 = require("../../hooks/useModuloWithTripleDots");
const CallButtons_1 = require("./CallButtons");
const CallManager_1 = require("../../bchat/utils/calling/CallManager");
const useInterval_1 = __importDefault(require("react-use/lib/useInterval"));
const moment_1 = __importDefault(require("moment"));
const BchatSpinner_1 = require("../basic/BchatSpinner");
const conversations_1 = require("../../state/selectors/conversations");
const conversations_2 = require("../../bchat/conversations");
const Flex_1 = require("../basic/Flex");
const Text_1 = require("../basic/Text");
const icon_1 = require("../icon");
const classnames_1 = __importDefault(require("classnames"));
const theme_1 = require("../../state/selectors/theme");
const VideoContainer = styled_components_1.default.div `

  height: 100%;

  width:${props => props.isCallModalExpandView && props.isPortrait
    ? '36%' :
    props.isPortrait && !props.isCallModalExpandView
        ? '491px' : '100%'};
  z-index: 0;
  display: flex;
  align-items: center;
  justify-content: ${({ isJustifyCenter }) => (isJustifyCenter ? 'center' : 'flex-end')};
  // padding-top: 30px; // leave some space at the top for the connecting/duration of the current call
  ${props => props.isPortrait && !props.isCallModalExpandView && `max-height:374px;overflow:hidden;`};
  // max-height:${props => (props.isPortrait && !props.isCallModalExpandView ? '374px' : 'unset')} ;
  // overflow:${props => (props.isPortrait && !props.isCallModalExpandView ? 'hidden' : 'unset')};
  border-radius: 15px;
`;
const StyledLocalVideoContainer = styled_components_1.default.div `
//  height:${props => (props.isCallModalExpandView && props.isTurnOnLocalVideo ? '80%' : '100%')};
 height:${props => props.isCallModalExpandView && props.isTurnOnRemoteVideo && props.isTurnOnLocalVideo
    ? '38%'
    : props.isTurnOnRemoteVideo && props.isTurnOnLocalVideo
        ? '29%'
        : props.isTurnOnLocalVideo
            ? "60%"
            : '80%'};
  width:${props => props.isCallModalExpandView && props.isTurnOnRemoteVideo && props.isTurnOnLocalVideo
    ? '18%'
    : props.isTurnOnRemoteVideo && props.isTurnOnLocalVideo
        ? '29%'
        : props.isTurnOnLocalVideo
            ? "35%"
            : '100%'};
  z-index: 0;
  display: flex;
  justify-content:${props => props.isTurnOnRemoteVideo || props.isTurnOnLocalVideo ? 'center' : 'flex-start'};
  align-items:${props => !props.isCallModalExpandView && props.isTurnOnRemoteVideo ? 'flex-end' : 'center'};
  padding-bottom:${props => !props.isCallModalExpandView && props.isTurnOnRemoteVideo ? '10px' : 'unset'};
  position:${props => props.isTurnOnRemoteVideo || props.isTurnOnLocalVideo ? 'absolute' : 'unset'}; 
  right:${props => props.isCallModalExpandView && props.isTurnOnRemoteVideo && props.isTurnOnLocalVideo
    ? '-18px'
    : props.isTurnOnRemoteVideo && props.isTurnOnLocalVideo
        ? '5%'
        : '2px'};
  bottom:${props => props.isCallModalExpandView && props.isTurnOnRemoteVideo && props.isTurnOnLocalVideo
    ? 'unset'
    : props.isTurnOnRemoteVideo && props.isTurnOnLocalVideo
        ? '24%'
        : 'unset'};
     
      ${props => props.isCallModalExpandView && props.isTurnOnRemoteVideo && props.isTurnOnLocalVideo &&
    ` min-width: 228px;
    max-height: 278px;`}

  
  
`;
const InConvoCallWindow = styled_components_1.default.div `
  padding: 1rem;
  // display: flex;

  // background-color: var(--color-inbox-background);

  // flex-shrink: 1;
  // min-height: 80px;
  // align-items: center;
  // flex-grow: 1;

  border-radius: 15px;
  background-color: var(--color-hop-bg);
  height: 100%;
  // margin-top: 20px;
`;
const RelativeCallWindow = styled_components_1.default.div `
  position: relative;
`;
exports.CenteredAvatarInConversation = styled_components_1.default.div `
 

  display: flex;
  align-items: center;
  width: ${props => (props.isFullScreen ? 'unset' : props.isCallModalExpandView ? '250px' : '180px')};
  flex-direction: column;

  margin-left: ${props => (props.isNeedBgColor ? 'auto' : 'unset')};
  background-color: ${props => (props.isNeedBgColor ? props.avatarBgColor : 'unset')};
  border-radius: ${props => (props.isNeedBgColor ? '16px' : 'unset')};
  padding: ${props => (props.isNeedBgColor ? '31px 0 9px' : 'unset')};
`;
exports.UserNameTxt = styled_components_1.default.div `
  font-size: 20px;
  height: 55px;
  width: 158px;
  text-align: center;
`;
exports.StyledCenteredLabel = styled_components_1.default.div `
  font-size: 16px;
`;
const StyledVideoCallLabel = styled_components_1.default.div `
  font-size: 14px;
  color: white;
  z-index: 99;
`;
const RingingLabel = ({ isOutSideInConvo }) => {
    const ongoingCallWithFocusedIsRinging = (0, react_redux_1.useSelector)(call_1.getCallWithFocusedConvoIsOffering);
    const modulatedStr = isOutSideInConvo
        ? window.i18n('ringing')
        : (0, useModuloWithTripleDots_1.useModuloWithTripleDots)(window.i18n('ringing'), 3, 1000);
    if (!ongoingCallWithFocusedIsRinging) {
        return null;
    }
    return react_1.default.createElement(exports.StyledCenteredLabel, null, modulatedStr);
};
exports.RingingLabel = RingingLabel;
const ConnectingLabel = () => {
    const ongoingCallWithFocusedIsConnecting = (0, react_redux_1.useSelector)(call_1.getCallWithFocusedConvosIsConnecting);
    const modulatedStr = (0, useModuloWithTripleDots_1.useModuloWithTripleDots)(window.i18n('establishingConnection'), 3, 1000);
    if (!ongoingCallWithFocusedIsConnecting) {
        return null;
    }
    return react_1.default.createElement(exports.StyledCenteredLabel, null, modulatedStr);
};
exports.ConnectingLabel = ConnectingLabel;
const DurationLabel = (props) => {
    const [callDuration, setCallDuration] = (0, react_1.useState)(undefined);
    const ongoingCallWithFocusedIsConnected = (0, react_redux_1.useSelector)(call_1.getCallWithFocusedConvosIsConnected);
    const { isVideoCall, isDraggable } = props;
    (0, useInterval_1.default)(() => {
        const duration = utils_1.CallManager.getCurrentCallDuration();
        if (duration) {
            setCallDuration(duration);
        }
    }, 100);
    if (!ongoingCallWithFocusedIsConnected || !callDuration || callDuration < 0) {
        return null;
    }
    const ms = callDuration * 1000;
    const d = moment_1.default.duration(ms);
    const dateString = Math.floor(d.asHours()) + moment_1.default.utc(ms).format(':mm:ss');
    if (isDraggable && isVideoCall) {
        return react_1.default.createElement(StyledVideoCallLabel, null, dateString);
    }
    return react_1.default.createElement(exports.StyledCenteredLabel, null, dateString);
};
exports.DurationLabel = DurationLabel;
const StyledSpinner = styled_components_1.default.div `
  height: 100%;
  width: ${props => (props.fullWidth ? '100%' : '50%')};
  display: flex;
  justify-content: center;
  align-items: center;
  position: absolute;
  z-index: -1;
`;
const VideoLoadingSpinner = (props) => {
    return (react_1.default.createElement(StyledSpinner, { fullWidth: props.fullWidth },
        react_1.default.createElement(BchatSpinner_1.BchatSpinner, { loading: true })));
};
exports.VideoLoadingSpinner = VideoLoadingSpinner;
const InConversationCallContainer = () => {
    const isInFullScreen = (0, react_redux_1.useSelector)(call_1.getCallIsInFullScreen);
    const ongoingCallPubkey = (0, react_redux_1.useSelector)(call_1.getHasOngoingCallWithPubkey);
    const ongoingCallWithFocused = (0, react_redux_1.useSelector)(call_1.getHasOngoingCallWithFocusedConvo);
    const selectedConversation = (0, react_redux_1.useSelector)(conversations_1.getSelectedConversation);
    const videoRefRemote = (0, react_1.useRef)(null);
    const videoRefLocal = (0, react_1.useRef)(null);
    const ourPubkey = utils_1.UserUtils.getOurPubKeyStrFromCache();
    const conversation = (0, conversations_2.getConversationController)().get(ourPubkey);
    const avatarBgColor = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark' ? '#131313' : '#FFF';
    const [isCallModalExpandView, setIsCallModalExpandView] = (0, react_1.useState)(false);
    const [isPortrait, setPortrait] = (0, react_1.useState)(false);
    const { currentConnectedAudioInputs, currentConnectedCameras, currentConnectedAudioOutputs, currentSelectedAudioOutput, localStream, localStreamVideoIsMuted, remoteStream, remoteStreamVideoIsMuted, isAudioMuted, isAudioOutputMuted, } = (0, useVideoEventListener_1.useVideoCallEventsListener)('InConversationCallContainer', true);
    if (videoRefRemote?.current && videoRefLocal?.current) {
        if (videoRefRemote.current.srcObject !== remoteStream) {
            videoRefRemote.current.srcObject = remoteStream;
        }
        if (videoRefLocal.current.srcObject !== localStream) {
            videoRefLocal.current.srcObject = localStream;
        }
        if (videoRefRemote.current) {
            if (currentSelectedAudioOutput === CallManager_1.DEVICE_DISABLED_DEVICE_ID) {
                videoRefRemote.current.muted = true;
            }
            else {
                void videoRefRemote.current?.setSinkId(currentSelectedAudioOutput);
                videoRefRemote.current.muted = false;
            }
        }
    }
    (0, react_1.useEffect)(() => {
        if (videoRefRemote?.current && videoRefLocal?.current) {
            videoRefRemote.current.srcObject = remoteStream;
            videoRefLocal.current.srcObject = localStream;
        }
    }, [remoteStream, videoRefRemote, videoRefLocal]);
    (0, react_1.useEffect)(() => {
        if (!videoRefRemote.current)
            return;
        const videoEl = videoRefRemote.current;
        const handleVideoResize = () => {
            if (!videoEl.videoWidth || !videoEl.videoHeight)
                return;
            if (videoEl.videoWidth < videoEl.videoHeight) {
                setPortrait(true);
            }
            else {
                setPortrait(false);
            }
        };
        videoEl.addEventListener("loadedmetadata", handleVideoResize);
        return () => {
            videoEl.removeEventListener("loadedmetadata", handleVideoResize);
        };
    }, [remoteStream]);
    if (isInFullScreen && videoRefRemote.current) {
        videoRefRemote.current.muted = true;
    }
    if (!ongoingCallWithFocused || !ongoingCallPubkey) {
        return null;
    }
    const validateMemberName = (memberName) => {
        if (memberName == selectedConversation?.id) {
            let staringTwoString = memberName.substring(0, 2);
            let lastString = memberName.substring(58, 66);
            return `${staringTwoString}...${lastString}`;
        }
        return memberName;
    };
    const isJustifyCenter = (!remoteStreamVideoIsMuted || !localStreamVideoIsMuted);
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)('voiceCall', isCallModalExpandView && 'expandView') },
        react_1.default.createElement(InConvoCallWindow, null,
            react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: 'flex-end' },
                react_1.default.createElement(icon_1.BchatIconButton, { iconType: isCallModalExpandView ? 'callCollapse' : 'callExpand', iconSize: 30, onClick: () => { setIsCallModalExpandView(!isCallModalExpandView); } })),
            react_1.default.createElement(RelativeCallWindow, null,
                react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "center", alignItems: "center", padding: '16px 0 0 0', height: isCallModalExpandView ? 'calc(100vh - 315px)' : 'unset' },
                    react_1.default.createElement(VideoContainer, { isJustifyCenter: isJustifyCenter, isPortrait: isPortrait, isCallModalExpandView: isCallModalExpandView },
                        react_1.default.createElement(DraggableCallContainer_1.StyledVideoElement, { ref: videoRefRemote, autoPlay: true, isVideoMuted: remoteStreamVideoIsMuted, width: isPortrait ? "100%" : '90%', height: "100%", isCallModalExpandView: isCallModalExpandView }),
                        remoteStreamVideoIsMuted && (react_1.default.createElement(exports.CenteredAvatarInConversation, { isCallModalExpandView: isCallModalExpandView },
                            react_1.default.createElement(Avatar_1.Avatar, { size: isCallModalExpandView ? Avatar_1.AvatarSize.XXXL : Avatar_1.AvatarSize.XXL, pubkey: ongoingCallPubkey, isBnsHolder: selectedConversation?.isBnsHolder }),
                            react_1.default.createElement(Text_1.SpacerXS, null),
                            react_1.default.createElement(exports.UserNameTxt, null, validateMemberName(selectedConversation?.profileName || selectedConversation?.id))))),
                    react_1.default.createElement(StyledLocalVideoContainer, { isCallModalExpandView: isCallModalExpandView, isTurnOnRemoteVideo: !remoteStreamVideoIsMuted, isTurnOnLocalVideo: !localStreamVideoIsMuted },
                        react_1.default.createElement(DraggableCallContainer_1.StyledVideoElement, { ref: videoRefLocal, autoPlay: true, muted: true, isVideoMuted: localStreamVideoIsMuted, width: "100%", height: "100%", isCallModalExpandView: isCallModalExpandView }),
                        localStreamVideoIsMuted && (react_1.default.createElement(exports.CenteredAvatarInConversation, { isCallModalExpandView: isCallModalExpandView, isNeedBgColor: !remoteStreamVideoIsMuted && localStreamVideoIsMuted, avatarBgColor: avatarBgColor },
                            react_1.default.createElement(Avatar_1.Avatar, { size: isCallModalExpandView ? Avatar_1.AvatarSize.XXXL : Avatar_1.AvatarSize.XXL, pubkey: ourPubkey, isBnsHolder: conversation?.attributes?.isBnsHolder }),
                            react_1.default.createElement(Text_1.SpacerXS, null),
                            react_1.default.createElement(exports.UserNameTxt, null, validateMemberName(conversation.attributes.profileName)))))),
                react_1.default.createElement(Text_1.SpacerLG, null),
                react_1.default.createElement(CallButtons_1.CallWindowControls, { currentConnectedAudioInputs: currentConnectedAudioInputs, currentConnectedCameras: currentConnectedCameras, isAudioMuted: isAudioMuted, currentConnectedAudioOutputs: currentConnectedAudioOutputs, isAudioOutputMuted: isAudioOutputMuted, localStreamVideoIsMuted: localStreamVideoIsMuted, remoteStreamVideoIsMuted: remoteStreamVideoIsMuted, isFullScreen: isInFullScreen, selectedName: validateMemberName(selectedConversation?.profileName || selectedConversation?.id), isCallModalExpandView: isCallModalExpandView })))));
};
exports.InConversationCallContainer = InConversationCallContainer;
