"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IncomingCallDialog = exports.CallWindow = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const styled_components_1 = __importDefault(require("styled-components"));
const useParamSelector_1 = require("../../hooks/useParamSelector");
const onionPath_1 = require("../../bchat/onions/onionPath");
const utils_1 = require("../../bchat/utils");
const CallManager_1 = require("../../bchat/utils/calling/CallManager");
const call_1 = require("../../state/selectors/call");
const Avatar_1 = require("../avatar/Avatar");
const Text_1 = require("../basic/Text");
const icon_1 = require("../icon");
const useModuloWithTripleDots_1 = require("../../hooks/useModuloWithTripleDots");
exports.CallWindow = styled_components_1.default.div `
  position: absolute;
  z-index: 9;
  padding: 1rem;
  top: 50vh;
  left: 50vw;
  transform: translate(-50%, -50%);
  display: flex;
  flex-direction: column;
  background-color:var(--color-hop-bg);
  border: var(--bchat-border);
`;
const IncomingCallAvatarContainer = styled_components_1.default.div `
    width: 134px;
    margin: auto;
`;
const UserName = styled_components_1.default.div `
  font-size: 24px;
  font-style: normal;
  font-weight: 500;
  line-height: normal;
  text-align: center;
   padding: 0 0 1rem 0;
`;
const IncomingTxt = styled_components_1.default.div `
  color: var(--color-hop-txt);
  text-align: center;
  font-family: Poppins;
  font-size: 16px;
  font-style: normal;
  font-weight: 400;
  line-height: normal;
`;
const IncomingCallDialog = () => {
    const hasIncomingCall = (0, react_redux_1.useSelector)(call_1.getHasIncomingCall);
    const incomingCallFromPubkey = (0, react_redux_1.useSelector)(call_1.getHasIncomingCallFrom);
    const isBnsHolder = (0, useParamSelector_1.useConversationBnsHolder)(incomingCallFromPubkey);
    const modulatedStr = (0, useModuloWithTripleDots_1.useModuloWithTripleDots)('Incoming...', 3, 1000);
    (0, react_1.useEffect)(() => {
        let timeout;
        if (incomingCallFromPubkey) {
            timeout = global.setTimeout(async () => {
                if (incomingCallFromPubkey) {
                    window.log.info(`call missed with ${(0, onionPath_1.ed25519Str)(incomingCallFromPubkey)} as the dialog was not interacted with for ${CallManager_1.callTimeoutMs} ms`);
                    await utils_1.CallManager.USER_rejectIncomingCallRequest(incomingCallFromPubkey);
                }
            }, CallManager_1.callTimeoutMs);
        }
        return () => {
            if (timeout) {
                global.clearTimeout(timeout);
            }
        };
    }, [incomingCallFromPubkey]);
    const handleAcceptIncomingCall = async () => {
        if (incomingCallFromPubkey) {
            await utils_1.CallManager.USER_acceptIncomingCallRequest(incomingCallFromPubkey);
        }
    };
    const handleDeclineIncomingCall = async () => {
        if (incomingCallFromPubkey) {
            await utils_1.CallManager.USER_rejectIncomingCallRequest(incomingCallFromPubkey);
        }
    };
    const from = (0, useParamSelector_1.useConversationUsername)(incomingCallFromPubkey);
    if (!hasIncomingCall || !incomingCallFromPubkey) {
        return null;
    }
    if (hasIncomingCall) {
        return (react_1.default.createElement("div", { className: "bchat-dialog modal" },
            react_1.default.createElement("div", { className: "bchat-modal" },
                react_1.default.createElement("div", { style: { width: '400px' } },
                    react_1.default.createElement(IncomingCallAvatarContainer, null,
                        react_1.default.createElement(Text_1.SpacerLG, null),
                        react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.XXL, pubkey: incomingCallFromPubkey, isBnsHolder: isBnsHolder })),
                    react_1.default.createElement(UserName, null, from),
                    react_1.default.createElement(IncomingTxt, null, modulatedStr),
                    react_1.default.createElement(Text_1.SpacerSM, null),
                    react_1.default.createElement("div", { className: "bchat-modal__button-group" },
                        react_1.default.createElement("div", { className: "hangingBtn", role: "button", style: {
                                backgroundColor: '#FC3B3B',
                            }, onClick: handleDeclineIncomingCall },
                            react_1.default.createElement(icon_1.BchatIcon, { iconSize: 27, iconType: "hangup", clipRule: "evenodd", fillRule: "evenodd" })),
                        react_1.default.createElement(Text_1.SpacerLG, null),
                        react_1.default.createElement("div", { className: "hangingBtn", role: "button", style: {
                                backgroundColor: '#108D32',
                            }, onClick: handleAcceptIncomingCall },
                            react_1.default.createElement(icon_1.BchatIcon, { iconSize: 27, iconType: "hangIn", clipRule: "evenodd", fillRule: "evenodd" })))))));
    }
    return null;
};
exports.IncomingCallDialog = IncomingCallDialog;
