"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatContactListPanel = void 0;
const react_1 = __importStar(require("react"));
const Flex_1 = require("../basic/Flex");
const Text_1 = require("../basic/Text");
const icon_1 = require("../icon");
const conversations_1 = require("../../state/selectors/conversations");
const react_redux_1 = require("react-redux");
const useParamSelector_1 = require("../../hooks/useParamSelector");
const classnames_1 = __importDefault(require("classnames"));
const BchatButton_1 = require("../basic/BchatButton");
const ContactEmptyIcon_1 = __importDefault(require("../icon/ContactEmptyIcon"));
const styled_components_1 = __importDefault(require("styled-components"));
const CheckBoxTickIcon_1 = __importDefault(require("../icon/CheckBoxTickIcon"));
const conversations_2 = require("../../bchat/conversations");
const conversations_3 = require("../../state/ducks/conversations");
const theme_1 = require("../../state/selectors/theme");
const Avatar_1 = require("../avatar/Avatar");
const BchatContactListPanel = (props) => {
    const [currentSearchTerm, setCurrentSearchTerm] = (0, react_1.useState)('');
    const privateAndBlockedContactsPubkeys = (0, react_redux_1.useSelector)(conversations_1.getPrivateAndBlockedContactsPubkeys);
    const quotedMessageProps = (0, react_redux_1.useSelector)(conversations_1.getQuotedMessage);
    const selectedConvoKey = (0, react_redux_1.useSelector)(conversations_1.getSelectedConversationKey);
    const [filteredNames, setFilteredNames] = (0, react_1.useState)(privateAndBlockedContactsPubkeys);
    const [selectedMemberIds, setSelectedMemberIds] = (0, react_1.useState)([]);
    const handleSearch = (event) => {
        filterContacts(event.target.value);
    };
    const filterContacts = (searchTxt) => {
        setCurrentSearchTerm(searchTxt);
        setFilteredNames(searchTxt
            ? privateAndBlockedContactsPubkeys.filter((pubkey) => {
                const convo = (0, conversations_2.getConversationController)().get(pubkey);
                const memberName = convo?.getNickname() || convo?.getName() || convo?.getProfileName();
                return memberName?.toLowerCase().includes(searchTxt.toLowerCase());
            })
            : privateAndBlockedContactsPubkeys);
    };
    function handleSelectMember(memberId) {
        if (selectedMemberIds.includes(memberId)) {
            return;
        }
        setSelectedMemberIds([...selectedMemberIds, memberId]);
    }
    function handleUnselectMember(unselectId) {
        setSelectedMemberIds(selectedMemberIds.filter(id => {
            return id !== unselectId;
        }));
    }
    const sendContact = () => {
        if (!selectedConvoKey || !selectedMemberIds?.length)
            return;
        const conversationController = (0, conversations_2.getConversationController)();
        const selectedConvo = conversationController.get(selectedConvoKey);
        let selectedMemberNames = [];
        for (let index = 0; index < selectedMemberIds.length; index++) {
            const firstMemberId = selectedMemberIds[index];
            const memberConvo = conversationController.get(firstMemberId);
            if (!selectedConvo || !memberConvo)
                return;
            const memberName = memberConvo.getNickname() ||
                memberConvo.getName() ||
                memberConvo.getProfileName() ||
                firstMemberId;
            selectedMemberNames.push(memberName);
        }
        const sharedContact = {
            address: JSON.stringify(selectedMemberIds),
            name: JSON.stringify(selectedMemberNames),
        };
        props.sendMessage({
            body: '',
            attachments: undefined,
            groupInvitation: undefined,
            preview: undefined,
            quote: quotedMessageProps,
            payment: undefined,
            sharedContact,
        });
        window.inboxStore?.dispatch((0, conversations_3.closeShareContact)());
    };
    return (react_1.default.createElement("div", { className: "contact-list" },
        react_1.default.createElement("div", { className: "contact-list-header" },
            react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: 'space-between', alignItems: "center", height: "70px", padding: "25px", className: "contact-list-header-title-wrapper" },
                react_1.default.createElement("span", { className: "contact-list-header-titleTxt" }, "Share Contacts"),
                react_1.default.createElement("span", { onClick: () => {
                        window.inboxStore?.dispatch((0, conversations_3.closeShareContact)());
                    }, className: "contact-list-header-closeBox" },
                    react_1.default.createElement(icon_1.BchatIconButton, { iconType: 'xWithCircle', iconSize: 26, iconColor: "var(--color-text)" })))),
        react_1.default.createElement(Text_1.SpacerSM, null),
        react_1.default.createElement("div", { className: "bchat-search-input" },
            react_1.default.createElement("div", { className: "search" },
                react_1.default.createElement(icon_1.BchatIcon, { iconSize: 20, iconType: "search" })),
            react_1.default.createElement("input", { value: currentSearchTerm, onChange: e => {
                    handleSearch(e);
                }, placeholder: 'Search People', maxLength: 26 }),
            !!currentSearchTerm.length && (react_1.default.createElement(icon_1.BchatIconButton, { iconSize: 24, iconType: "exit", onClick: () => {
                    filterContacts('');
                } }))),
        react_1.default.createElement(Text_1.SpacerSM, null),
        react_1.default.createElement("div", { className: "contact-list-inner-wrapper" },
            filteredNames.length > 0 &&
                filteredNames.map(item => (react_1.default.createElement(ContactList, { pubkey: item, key: item, isSelected: selectedMemberIds.some(m => m === item), onSelect: selectedMember => {
                        handleSelectMember(selectedMember);
                    }, onUnselect: unselectedMember => {
                        handleUnselectMember(unselectedMember);
                    } }))),
            filteredNames.length === 0 && react_1.default.createElement(SearchEmptyScreen, null)),
        react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "center", alignItems: "center", padding: "13px 0", width: "100%", className: "button-wrapper" },
            react_1.default.createElement(BchatButton_1.BchatButton, { text: window.i18n('send'), buttonType: BchatButton_1.BchatButtonType.Brand, buttonColor: BchatButton_1.BchatButtonColor.Primary, disabled: selectedMemberIds.length === 0, onClick: sendContact }))));
};
exports.BchatContactListPanel = BchatContactListPanel;
const ContactList = (props) => {
    const { isSelected, pubkey, onSelect, onUnselect } = props;
    const username = (0, useParamSelector_1.useConversationUsernameOrShorten)(pubkey);
    const isBnsHolder = (0, useParamSelector_1.useConversationBnsHolder)(pubkey);
    const selectionValidation = isSelected;
    return (react_1.default.createElement(react_1.default.Fragment, null,
        react_1.default.createElement("div", { className: (0, classnames_1.default)(`address-content-box ${selectionValidation && 'selected'}`), style: { cursor: 'pointer' }, onClick: () => {
                isSelected ? onUnselect?.(pubkey) : onSelect?.(pubkey);
            } },
            react_1.default.createElement("div", { className: "avatarBox" },
                react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.M, pubkey: pubkey, isBnsHolder: isBnsHolder })),
            react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "column", margin: "0 15px" },
                react_1.default.createElement("div", null,
                    react_1.default.createElement("span", { className: (0, classnames_1.default)('username') }, username)),
                react_1.default.createElement(Text_1.SpacerXS, null),
                react_1.default.createElement("div", { className: 'address', style: { cursor: 'pointer' } }, pubkey)),
            react_1.default.createElement("span", { className: (0, classnames_1.default)('bchat-member-item__checkmark', selectionValidation && 'selected') }, selectionValidation ? (react_1.default.createElement(CheckBoxTickIcon_1.default, { iconSize: 26 })) : (react_1.default.createElement(icon_1.BchatIcon, { iconType: 'checkBox', clipRule: "evenodd", fillRule: "evenodd", iconSize: 26 })))),
        react_1.default.createElement(Text_1.SpacerXS, null)));
};
const SearchEmptyScreen = () => {
    const isDark = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark';
    return (react_1.default.createElement(SearchEmptyWrapper, null,
        react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "column", justifyContent: "center", alignItems: "center" },
            react_1.default.createElement(ContactEmptyIcon_1.default, { isDark: isDark }),
            react_1.default.createElement(StyledSpan, null, "No Contact Found!"))));
};
const SearchEmptyWrapper = styled_components_1.default.div `
  height: calc(100vh - 286px);
  width: 100%;
  display: flex;
`;
const StyledSpan = styled_components_1.default.span `
  color: #a7a7ba;
  text-align: center;
  font-family: $bchat-font-open-sans;
  font-size: 16px;
  font-style: normal;
  font-weight: 600;
  line-height: normal;
`;
