"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateDraftForConversation = exports.getDraftForConversation = void 0;
const draftsForConversations = {};
function getDraftForConversation(conversationKey) {
    if (!conversationKey || !draftsForConversations[conversationKey]) {
        return '';
    }
    return draftsForConversations[conversationKey] || '';
}
exports.getDraftForConversation = getDraftForConversation;
function updateDraftForConversation({ conversationKey, draft, }) {
    draftsForConversations[conversationKey] = draft;
}
exports.updateDraftForConversation = updateDraftForConversation;
