"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatFileDropzone = void 0;
const react_1 = __importDefault(require("react"));
const styled_components_1 = __importDefault(require("styled-components"));
const Flex_1 = require("../basic/Flex");
const icon_1 = require("../icon");
const DropZoneContainer = styled_components_1.default.div `
  display: inline-block;
  position: absolute;
  width: 100%;
  height: 100%;
  pointer-events: none;
`;
const DropZoneWithBorder = styled_components_1.default.div `
  border: dashed 4px var(--color-accent);
  background-color: var(--color-clickable-hovered);
  position: absolute;
  top: 0;
  bottom: 0;
  left: 0;
  right: 0;
  z-index: 20;
  opacity: 0.5;
  pointer-events: none;
`;
const BchatFileDropzone = () => {
    return (react_1.default.createElement(DropZoneContainer, null,
        react_1.default.createElement(DropZoneWithBorder, null,
            react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "space-around", height: "100%", alignItems: "center" },
                react_1.default.createElement(icon_1.BchatIcon, { iconSize: 'max', iconType: "circlePlus" })))));
};
exports.BchatFileDropzone = BchatFileDropzone;
