"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatMessagesList = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const useKey_1 = __importDefault(require("react-use/lib/useKey"));
const conversations_1 = require("../../state/selectors/conversations");
const GroupUpdateMessage_1 = require("./message/message-item/GroupUpdateMessage");
const MessageRequestResponse_1 = require("./message/message-item/MessageRequestResponse");
const DateBreak_1 = require("./message/message-item/DateBreak");
const Message_1 = require("./message/message-item/Message");
const CallNotification_1 = require("./message/message-item/notification-bubble/CallNotification");
const BchatLastSeenIndicator_1 = require("./BchatLastSeenIndicator");
const TimerNotification_1 = require("./TimerNotification");
const DataExtractionNotification_1 = require("./message/message-item/DataExtractionNotification");
const walletConfig_1 = require("../../state/selectors/walletConfig");
function isNotTextboxEvent(e) {
    return e?.target?.type === undefined;
}
const BchatMessagesList = (props) => {
    const messagesProps = (0, react_redux_1.useSelector)(conversations_1.getSortedMessagesTypesOfSelectedConversation);
    const oldTopMessageId = (0, react_redux_1.useSelector)(conversations_1.getOldTopMessageId);
    const oldBottomMessageId = (0, react_redux_1.useSelector)(conversations_1.getOldBottomMessageId);
    const transactionInitiatDetails = (0, react_redux_1.useSelector)(walletConfig_1.getWalletPaymentDetailsSend);
    (0, react_1.useLayoutEffect)(() => {
        const newTopMessageId = messagesProps.length
            ? messagesProps[messagesProps.length - 1].message.props.messageId
            : undefined;
        if (oldTopMessageId !== newTopMessageId && oldTopMessageId && newTopMessageId) {
            props.scrollAfterLoadMore(oldTopMessageId, 'load-more-top');
        }
        const newBottomMessageId = messagesProps.length
            ? messagesProps[0].message.props.messageId
            : undefined;
        if (newBottomMessageId !== oldBottomMessageId && oldBottomMessageId && newBottomMessageId) {
            props.scrollAfterLoadMore(oldBottomMessageId, 'load-more-bottom');
        }
    });
    (0, useKey_1.default)('PageUp', () => {
        props.onPageUpPressed();
    });
    (0, useKey_1.default)('PageDown', () => {
        props.onPageDownPressed();
    });
    (0, useKey_1.default)('Home', e => {
        if (isNotTextboxEvent(e)) {
            props.onHomePressed();
        }
    });
    (0, useKey_1.default)('End', e => {
        if (isNotTextboxEvent(e)) {
            props.onEndPressed();
        }
    });
    if (props.pubkey === transactionInitiatDetails?.message?.props?.id) {
        function checkKey(key) {
            return key?.message?.props?.messageId === transactionInitiatDetails?.message?.props?.messageId;
        }
        if (!messagesProps.find(checkKey)) {
            messagesProps.unshift(transactionInitiatDetails);
        }
    }
    return (react_1.default.createElement(react_1.default.Fragment, null, messagesProps.map(messageProps => {
        const messageId = messageProps.message.props.messageId;
        const unreadIndicator = messageProps.showUnreadIndicator ? (react_1.default.createElement(BchatLastSeenIndicator_1.BchatLastSeenIndicator, { key: `unread-indicator-${messageId}`, messageId: messageId })) : null;
        const dateBreak = messageProps.showDateBreak !== undefined ? (react_1.default.createElement(DateBreak_1.MessageDateBreak, { key: `date-break-${messageId}`, timestamp: messageProps.showDateBreak, messageId: messageId })) : null;
        if (messageProps.message?.messageType === 'group-notification') {
            const msgProps = messageProps.message.props;
            return [react_1.default.createElement(GroupUpdateMessage_1.GroupUpdateMessage, { key: messageId, ...msgProps }), dateBreak, unreadIndicator];
        }
        if (messageProps.message?.messageType === 'group-invitation') {
            const msgProps = messageProps.message.props;
            return [react_1.default.createElement(Message_1.Message, { key: messageId, ...msgProps }), dateBreak, unreadIndicator];
        }
        if (messageProps.message?.messageType === 'payment') {
            const msgProps = messageProps.message.props;
            return [react_1.default.createElement(Message_1.Message, { key: messageId, ...msgProps }), dateBreak, unreadIndicator];
        }
        if (messageProps.message?.messageType === 'shared-contact') {
            const msgProps = messageProps.message.props;
            return [react_1.default.createElement(Message_1.Message, { key: messageId, ...msgProps }), dateBreak, unreadIndicator];
        }
        if (messageProps.message?.messageType === 'message-request-response') {
            const msgProps = messageProps.message.props;
            return [
                react_1.default.createElement(MessageRequestResponse_1.MessageRequestResponse, { key: messageId, ...msgProps }),
                dateBreak,
                unreadIndicator,
            ];
        }
        if (messageProps.message?.messageType === 'data-extraction') {
            const msgProps = messageProps.message.props;
            return [
                react_1.default.createElement(DataExtractionNotification_1.DataExtractionNotification, { key: messageId, ...msgProps }),
                dateBreak,
                unreadIndicator,
            ];
        }
        if (messageProps.message?.messageType === 'timer-notification') {
            const msgProps = messageProps.message.props;
            return [react_1.default.createElement(TimerNotification_1.TimerNotification, { key: messageId, ...msgProps }), dateBreak, unreadIndicator];
        }
        if (messageProps.message?.messageType === 'call-notification') {
            const msgProps = messageProps.message.props;
            return [react_1.default.createElement(CallNotification_1.CallNotification, { key: messageId, ...msgProps }), dateBreak, unreadIndicator];
        }
        if (!messageProps) {
            return null;
        }
        return [react_1.default.createElement(Message_1.Message, { messageId: messageId, key: messageId }), dateBreak, unreadIndicator];
    })));
};
exports.BchatMessagesList = BchatMessagesList;
