"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatMessagesListContainer = exports.ScrollToLoadedMessageContext = exports.messageContainerDomID = void 0;
const react_1 = __importDefault(require("react"));
const react_contexify_1 = require("react-contexify");
const react_redux_1 = require("react-redux");
const BchatMessagesList_1 = require("./BchatMessagesList");
const auto_bind_1 = __importDefault(require("auto-bind"));
const conversations_1 = require("../../state/ducks/conversations");
const conversations_2 = require("../../state/selectors/conversations");
const styled_components_1 = __importDefault(require("styled-components"));
exports.messageContainerDomID = 'messages-container';
exports.ScrollToLoadedMessageContext = react_1.default.createContext((_loadedMessageIdToScrollTo, _reason) => { });
const StyledMessagesContainer = styled_components_1.default.div `
  display: flex;
  flex-grow: 1;
  flex-direction: column-reverse;
  position: relative;
  overflow-x: hidden;
  min-width: 370px;
  scrollbar-width: 4px;
  padding: var(--margins-sm) 0 var(--margins-lg);
  .session-icon-button {
    display: flex;
    justify-content: center;
    align-items: center;
    height: 40px;
    width: 40px;
    border-radius: 50%;
    opacity: 1;
    background-color: var(--color-cell-background);
    box-shadow: var(--color-session-shadow);
    svg path {
      transition: var(--default-duration);
      opacity: 0.6;
      fill: var(--color-text);
    }
    &:hover svg path {
      opacity: 1;
    }
  }
`;
class BchatMessagesListContainerInner extends react_1.default.Component {
    timeoutResetQuotedScroll = null;
    constructor(props) {
        super(props);
        (0, auto_bind_1.default)(this);
    }
    componentWillUnmount() {
        if (this.timeoutResetQuotedScroll) {
            global.clearTimeout(this.timeoutResetQuotedScroll);
        }
    }
    componentDidUpdate(prevProps, _prevState) {
        const isSameConvo = prevProps.conversationKey === this.props.conversationKey;
        if (!isSameConvo &&
            this.props.messagesProps.length &&
            this.props.messagesProps[0].propsForMessage.convoId === this.props.conversationKey) {
            this.setupTimeoutResetQuotedHighlightedMessage(this.props.animateQuotedMessageId);
        }
    }
    render() {
        const { conversationKey, conversation } = this.props;
        if (!conversationKey || !conversation) {
            return null;
        }
        return (react_1.default.createElement(StyledMessagesContainer, { className: "messages-container", id: exports.messageContainerDomID, onScroll: this.handleScroll, ref: this.props.messageContainerRef, "data-testid": "messages-container" },
            react_1.default.createElement(exports.ScrollToLoadedMessageContext.Provider, { value: this.scrollToLoadedMessage },
                react_1.default.createElement(BchatMessagesList_1.BchatMessagesList, { scrollAfterLoadMore: (messageIdToScrollTo, type) => {
                        this.scrollToMessage(messageIdToScrollTo, type);
                    }, onPageDownPressed: this.scrollPgDown, onPageUpPressed: this.scrollPgUp, onHomePressed: this.scrollTop, onEndPressed: this.scrollEnd, pubkey: conversationKey }))));
    }
    handleScroll() {
        react_contexify_1.contextMenu.hideAll();
    }
    setupTimeoutResetQuotedHighlightedMessage(messageId) {
        if (this.timeoutResetQuotedScroll) {
            global.clearTimeout(this.timeoutResetQuotedScroll);
        }
        if (messageId !== undefined) {
            this.timeoutResetQuotedScroll = global.setTimeout(() => {
                window.inboxStore?.dispatch((0, conversations_1.quotedMessageToAnimate)(undefined));
            }, 2000);
        }
    }
    scrollToMessage(messageId, reason) {
        const messageElementDom = document.getElementById(`msg-${messageId}`);
        const messageContainerDom = document.getElementById(exports.messageContainerDomID);
        switch (reason) {
            case 'load-more-bottom':
                messageElementDom?.scrollIntoView({
                    behavior: 'auto',
                    block: 'end',
                });
                window.inboxStore?.dispatch((0, conversations_1.resetOldBottomMessageId)());
                break;
            case 'load-more-top':
                messageElementDom?.scrollIntoView({
                    behavior: 'auto',
                    block: 'start',
                });
                window.inboxStore?.dispatch((0, conversations_1.resetOldTopMessageId)());
                break;
            case 'quote-or-search-result':
                messageElementDom?.scrollIntoView({
                    behavior: 'auto',
                    block: 'start',
                });
                messageContainerDom?.scrollBy({ top: -50 });
                break;
            case 'go-to-bottom':
                messageElementDom?.scrollIntoView({
                    behavior: 'auto',
                    block: 'end',
                });
                messageContainerDom?.scrollBy({ top: 200 });
                break;
            case 'unread-indicator':
                messageElementDom?.scrollIntoView({
                    behavior: 'auto',
                    block: 'center',
                });
                messageContainerDom?.scrollBy({ top: -50 });
                break;
            default:
        }
    }
    scrollPgUp() {
        const messageContainer = this.props.messageContainerRef.current;
        if (!messageContainer) {
            return;
        }
        messageContainer.scrollBy({
            top: Math.floor(-messageContainer.clientHeight * 2) / 3,
            behavior: 'smooth',
        });
    }
    scrollPgDown() {
        const messageContainer = this.props.messageContainerRef.current;
        if (!messageContainer) {
            return;
        }
        messageContainer.scrollBy({
            top: Math.floor(+messageContainer.clientHeight * 2) / 3,
            behavior: 'smooth',
        });
    }
    scrollTop() {
        const messageContainer = this.props.messageContainerRef.current;
        if (!messageContainer) {
            return;
        }
        messageContainer.scrollTo(0, -messageContainer.scrollHeight);
    }
    scrollEnd() {
        const messageContainer = this.props.messageContainerRef.current;
        if (!messageContainer) {
            return;
        }
        messageContainer.scrollTo(0, 0);
    }
    scrollToLoadedMessage(loadedMessageToScrollTo, reason) {
        if (!this.props.conversationKey || !loadedMessageToScrollTo) {
            return;
        }
        const { messagesProps } = this.props;
        if (!messagesProps.find(m => m.propsForMessage.id === loadedMessageToScrollTo)) {
            throw new Error('this message is not loaded');
        }
        this.scrollToMessage(loadedMessageToScrollTo, reason);
        if (reason === 'quote-or-search-result') {
            window.inboxStore?.dispatch((0, conversations_1.quotedMessageToAnimate)(loadedMessageToScrollTo));
            this.setupTimeoutResetQuotedHighlightedMessage(loadedMessageToScrollTo);
        }
    }
}
const mapStateToProps = (state) => {
    return {
        conversationKey: (0, conversations_2.getSelectedConversationKey)(state),
        conversation: (0, conversations_2.getSelectedConversation)(state),
        messagesProps: (0, conversations_2.getSortedMessagesOfSelectedConversation)(state),
        animateQuotedMessageId: (0, conversations_2.getQuotedMessageToAnimate)(state),
    };
};
const smart = (0, react_redux_1.connect)(mapStateToProps);
exports.BchatMessagesListContainer = smart(BchatMessagesListContainerInner);
