"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatQuotedMessageComposition = void 0;
const react_1 = __importStar(require("react"));
const icon_1 = require("../icon");
const styled_components_1 = __importDefault(require("styled-components"));
const react_redux_1 = require("react-redux");
const conversations_1 = require("../../state/ducks/conversations");
const conversations_2 = require("../../state/selectors/conversations");
const Attachment_1 = require("../../types/Attachment");
const MIME_1 = require("../../types/MIME");
const Flex_1 = require("../basic/Flex");
const Image_1 = require("./Image");
const util_1 = require("../../util");
const classnames_1 = __importDefault(require("classnames"));
const GroupInvitation_1 = require("./message/message-item/GroupInvitation");
const BchatJoinableDefaultRooms_1 = require("../leftpane/overlay/BchatJoinableDefaultRooms");
const QuotedMessageComposition = styled_components_1.default.div `
  width: 100%;
  margin-top: 15px;
  // padding-inline-end: var(--margins-md);
  // padding-inline-start: var(--margins-md);
`;
const QuotedMessageCompositionReply = styled_components_1.default.div `
  // background: var(--color-quote-bottom-bar-background);
  // border-radius: var(--margins-sm);
  padding: var(--margins-xs);
  box-shadow: var(--color-bchat-shadow);
  // margin: var(--margins-xs);
  background: var(--color-untrust-media-bg);
  border-radius: 16px;
  min-height: 70px;
  width: 100%;
  margin-right: 10px;

  .group-details {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 15px 0;
    min-width: 249px;
    .group-name {
      font-weight: 600;
    }
    .group-type {
      overflow: hidden;
      text-overflow: ellipsis;
      font-weight: 300;
    }
  }
`;
const Subtle = styled_components_1.default.div `
  overflow: hidden;
  text-overflow: ellipsis;
  word-break: break-all;
  -webkit-line-clamp: 2;
  -webkit-box-orient: vertical;
  display: -webkit-box;
  color: var(--color-text);
  margin-right: 9px;
`;
const VerticalLine = styled_components_1.default.div `
  width: 5px;
  background-color: var(--color-untrusted-vertical-bar);
  height: 60px;
  border-radius: 10px;
  margin-right: 10px;
`;
const StyledIconWrapper = styled_components_1.default.div `
  width: 50px;
  height: 50px;
  background-color: var(--color-hop-bg);
  display: flex;
  justify-content: center;
  align-items: center;
  margin-right: 15px;
  border-radius: 10px;
`;
const BchatQuotedMessageComposition = () => {
    const quotedMessageProps = (0, react_redux_1.useSelector)(conversations_2.getQuotedMessage);
    const joinableRooms = (0, react_redux_1.useSelector)((state) => state.defaultRooms);
    const dispatch = (0, react_redux_1.useDispatch)();
    const { text: body, attachments, direction } = quotedMessageProps || {};
    let groupInvitation;
    let sharedContactList;
    let paymentDetails;
    const hasAttachments = attachments && attachments.length > 0;
    const SUPPORTED_PROTOCOLS = /^(http|https):/i;
    const isLink = SUPPORTED_PROTOCOLS.test(body || '');
    let hasImageAttachment = false;
    let firstImageAttachment;
    if (attachments?.length && attachments[0].contentType !== MIME_1.AUDIO_MP3 && attachments[0].thumbnail) {
        firstImageAttachment = attachments[0];
        hasImageAttachment = true;
    }
    const hasAudioAttachment = hasAttachments && attachments && attachments.length > 0 && (0, Attachment_1.isAudio)(attachments);
    const hasImageAttachmentNotTrusted = hasAttachments &&
        util_1.GoogleChrome.isImageTypeSupported(attachments[0].contentType) &&
        !attachments[0].thumbnail;
    const hasPdfAttachmentNotTrusted = hasAttachments && attachments[0]?.contentType === 'application/pdf';
    const hasVideoAttachment = hasAttachments && util_1.GoogleChrome.isVideoTypeSupported(attachments[0]?.contentType);
    const getIconType = () => {
        if (hasImageAttachmentNotTrusted)
            return 'image';
        if (hasPdfAttachmentNotTrusted)
            return 'file';
        if (!hasImageAttachment && hasVideoAttachment)
            return 'movie';
        return null;
    };
    const iconType = getIconType();
    const removeQuotedMessage = (0, react_1.useCallback)(() => {
        dispatch((0, conversations_1.quoteMessage)(undefined));
    }, []);
    if (!quotedMessageProps?.id) {
        return null;
    }
    if (body && body.startsWith(`{"kind"`)) {
        const parsed = JSON.parse(body);
        if (parsed.kind['@type'] === 'OpenGroupInvitation') {
            groupInvitation = {
                name: parsed.kind.groupName,
                url: parsed.kind.groupUrl,
            };
        }
        if (parsed.kind['@type'] === 'Payment') {
            const types = direction === 'incoming' ? 'Received' : 'Sent';
            paymentDetails = {
                amount: parsed.kind.amount,
                txnId: parsed.kind.txnId,
                msgType: types
            };
        }
        if (parsed.kind['@type'] === 'SharedContact') {
            sharedContactList = {
                address: parsed.kind.address,
                name: parsed.kind.name
            };
        }
    }
    const namesArray = sharedContactList?.name && JSON.parse(sharedContactList.name);
    const socialGrp = joinableRooms.rooms.filter((item) => groupInvitation?.name === item.name);
    const validatedBody = !body?.startsWith(`{"kind"`) && body;
    return (react_1.default.createElement(QuotedMessageComposition, null,
        react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "space-between", flexGrow: 1, margin: 'var(--margins-xs)', alignItems: "center" },
            react_1.default.createElement(QuotedMessageCompositionReply, null,
                react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "flex-start", margin: 'var(--margins-xs)', alignItems: "center" },
                    !isLink ? (react_1.default.createElement(VerticalLine, null)) : (react_1.default.createElement(StyledIconWrapper, null,
                        react_1.default.createElement(icon_1.BchatIcon, { iconType: "openLink", iconSize: 20, iconColor: "var(--color-modal-disable-txt)" }))),
                    react_1.default.createElement(Subtle, null, (hasAttachments && window.i18n('mediaMessage')) || validatedBody),
                    groupInvitation && (react_1.default.createElement("div", { className: "group-details" },
                        react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "column", cursor: "pointer" },
                            react_1.default.createElement("span", { className: "group-name", style: { fontSize: `${(0, GroupInvitation_1.FontSizeChanger)(18)}px` } }, groupInvitation.name),
                            react_1.default.createElement("span", { className: "group-type", style: { fontSize: `${(0, GroupInvitation_1.FontSizeChanger)(14)}px` } }, window.i18n('socialGroupInvitation'))),
                        react_1.default.createElement(BchatJoinableDefaultRooms_1.BchatJoinableRoomAvatar, { completeUrl: socialGrp[0]?.completeUrl, name: socialGrp[0]?.name, roomId: socialGrp[0]?.id, base64Data: socialGrp[0]?.base64Data, onClick: () => { } }))),
                    paymentDetails && (react_1.default.createElement("div", { className: "group-details" },
                        react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "column", cursor: "pointer" },
                            react_1.default.createElement("span", { className: "group-name", style: { fontSize: `${(0, GroupInvitation_1.FontSizeChanger)(18)}px` } }, window.i18n('paymentDetails', [
                                paymentDetails.msgType,
                            ])),
                            react_1.default.createElement("span", { className: "group-type", style: { fontSize: `${(0, GroupInvitation_1.FontSizeChanger)(14)}px` } },
                                paymentDetails.amount,
                                " BDX")))),
                    sharedContactList && (react_1.default.createElement("div", { className: "group-details" },
                        react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "column", cursor: "pointer" },
                            react_1.default.createElement("span", { className: "group-name", style: { fontSize: `${(0, GroupInvitation_1.FontSizeChanger)(18)}px` } }, "Shared contact"),
                            react_1.default.createElement("span", { className: "group-type", style: { fontSize: `${(0, GroupInvitation_1.FontSizeChanger)(14)}px`, textTransform: 'capitalize' } },
                                react_1.default.createElement("span", { style: { marginRight: '5px' } },
                                    react_1.default.createElement(icon_1.BchatIcon, { iconType: 'avatarOutline', iconSize: 13, strokeWidth: '1px', strokeColor: 'var(--color-text)', iconColor: 'var(--color-text)' })),
                                namesArray.length > 1
                                    ? `${namesArray[0]} and ${namesArray.length - 1} other${namesArray.length > 2 ? 's' : ''}`
                                    : namesArray[0] ?? '')))),
                    hasImageAttachment && (react_1.default.createElement(Image_1.Image, { alt: (0, Attachment_1.getAlt)(firstImageAttachment), attachment: firstImageAttachment, height: 100, width: 100, url: firstImageAttachment.thumbnail.objectUrl })),
                    iconType && (react_1.default.createElement("div", { className: (0, classnames_1.default)('module-quote__icon-container__icon', `module-quote__icon-container__icon--${iconType}`) })),
                    hasAudioAttachment && react_1.default.createElement(icon_1.BchatIcon, { iconType: "microphone", iconSize: "huge" }))),
            react_1.default.createElement(icon_1.BchatIconButton, { iconType: "exit", iconSize: 24, onClick: removeQuotedMessage }))));
};
exports.BchatQuotedMessageComposition = BchatQuotedMessageComposition;
