"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BchatRecording = void 0;
const react_1 = __importDefault(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const moment_1 = __importDefault(require("moment"));
const icon_1 = require("../icon");
const auto_bind_1 = __importDefault(require("auto-bind"));
const mic_recorder_to_mp3_1 = __importDefault(require("mic-recorder-to-mp3"));
const styled_components_1 = __importDefault(require("styled-components"));
const bchat_1 = require("../../bchat");
const utils_1 = require("../../bchat/utils");
const constants_1 = require("../../bchat/constants");
const CompositionButtons_1 = require("./composition/CompositionButtons");
const StopIcon_1 = __importDefault(require("../icon/StopIcon"));
const CustomIconButton_1 = require("../icon/CustomIconButton");
const userConfig_1 = require("../../state/ducks/userConfig");
const BchatQuotedMessageComposition_1 = require("./BchatQuotedMessageComposition");
function getTimestamp() {
    return Date.now() / 1000;
}
const StyledFlexWrapper = styled_components_1.default.div `
  display: flex;
  flex-direction: row;
  align-items: center;
  // width:100%;
  justify-content: space-between;
  width: 65px;
  .bchat-icon-button{
    border-radius:30px;
  }
  
  }
`;
class BchatRecording extends react_1.default.Component {
    recorder;
    audioBlobMp3;
    audioElement;
    updateTimerInterval;
    constructor(props) {
        super(props);
        (0, auto_bind_1.default)(this);
        const now = getTimestamp();
        this.state = {
            recordDuration: 0,
            isRecording: true,
            isPlaying: false,
            isPaused: false,
            actionHover: false,
            startTimestamp: now,
            nowTimestamp: now,
        };
    }
    componentDidMount() {
        void this.initiateRecordingStream();
        if (this.props.onLoadVoiceNoteView) {
            this.props.onLoadVoiceNoteView();
        }
        this.updateTimerInterval = global.setInterval(this.timerUpdate, 500);
    }
    componentWillUnmount() {
        if (this.updateTimerInterval) {
            clearInterval(this.updateTimerInterval);
        }
    }
    render() {
        const { isPlaying, isPaused, isRecording, startTimestamp, nowTimestamp } = this.state;
        const hasRecordingAndPaused = !isRecording && !isPlaying;
        const hasRecording = !!this.audioElement?.duration && this.audioElement?.duration > 0;
        const actionPauseAudio = !isRecording && !isPaused && isPlaying;
        const actionDefault = !isRecording && !hasRecordingAndPaused && !actionPauseAudio;
        const isNotPlayed = this.audioElement?.currentTime !== this.audioElement?.duration;
        const displayTimeMs = isRecording
            ? (nowTimestamp - startTimestamp) * 1000
            : (this.audioElement &&
                (isNotPlayed && this.audioElement?.currentTime * 1000 || this.audioElement?.duration)) ||
                0;
        const displayTimeString = moment_1.default.utc(displayTimeMs).format('m:ss');
        const recordingDurationMs = this.audioElement?.duration
            ? this.audioElement?.duration * 1000
            : 1;
        let remainingTimeString = '';
        if (recordingDurationMs !== undefined) {
            remainingTimeString = ` / ${moment_1.default.utc(recordingDurationMs).format('m:ss')}`;
        }
        const actionPauseFn = isPlaying ? this.pauseAudio : this.stopRecordingStream;
        return (react_1.default.createElement("div", { role: "main", className: "bchat-recording", tabIndex: 0, onKeyDown: this.onKeyDown },
            react_1.default.createElement("div", { className: "send-message-input" },
                react_1.default.createElement(BchatQuotedMessageComposition_1.BchatQuotedMessageComposition, null),
                react_1.default.createElement("div", { className: "bchat-recording-box" },
                    hasRecording && !isRecording ? (react_1.default.createElement("div", { className: (0, classnames_1.default)('bchat-recording--timer', !isRecording && 'playback-timer') },
                        react_1.default.createElement("div", { className: 'bchat-recording--timer-micIcon' },
                            react_1.default.createElement(icon_1.BchatIcon, { iconType: "recordMicrophone", iconSize: 20 })),
                        displayTimeString + remainingTimeString)) : null,
                    react_1.default.createElement("div", null, isRecording ? (react_1.default.createElement("div", { className: (0, classnames_1.default)('bchat-recording--timer') },
                        react_1.default.createElement("div", { className: "bchat-recording--timer-wrapper" },
                            react_1.default.createElement("div", { className: "bchat-recording--timer-light" })),
                        displayTimeString)) : null),
                    react_1.default.createElement("div", { className: "bchat-recording--actions" },
                        react_1.default.createElement(StyledFlexWrapper, null,
                            actionPauseAudio && hasRecording && (react_1.default.createElement(icon_1.BchatIconButton, { iconType: "pause", iconSize: "medium", onClick: actionPauseFn, iconColor: "#277AFB" })),
                            hasRecordingAndPaused && (react_1.default.createElement(icon_1.BchatIconButton, { iconType: "play", iconSize: 14, onClick: () => hasRecording && this.playAudio(), iconColor: "#F0F0F0", btnBgColor: "#108D32", padding: "8px" })),
                            !isRecording && (react_1.default.createElement(icon_1.BchatIconButton, { iconType: "delete", iconSize: "medium", onClick: this.onDeleteVoiceMessage, iconColor: "#F0F0F0", btnBgColor: "#FF3E3E", padding: "5px" }))),
                        actionDefault && react_1.default.createElement(icon_1.BchatIconButton, { iconType: "microphone", iconSize: 'huge' })),
                    isRecording && (react_1.default.createElement(CustomIconButton_1.CustomIconButton, { customIcon: react_1.default.createElement(StopIcon_1.default, { iconSize: 30 }), onClick: actionPauseFn })))),
            react_1.default.createElement("div", { className: (0, classnames_1.default)('send-message-button', !hasRecording && !isRecording && 'delete-button') }, !isRecording && hasRecording && (react_1.default.createElement(CompositionButtons_1.SendMessageButton, { name: "Send", onClick: this.onSendVoiceMessage })))));
    }
    async timerUpdate() {
        const { nowTimestamp, startTimestamp } = this.state;
        const elapsedTime = nowTimestamp - startTimestamp;
        if (elapsedTime >= bchat_1.Constants.CONVERSATION.MAX_VOICE_MESSAGE_DURATION) {
            await this.stopRecordingStream();
        }
        this.setState({
            nowTimestamp: getTimestamp(),
        });
    }
    stopRecordingState() {
        this.setState({
            isRecording: false,
            isPaused: true,
        });
    }
    async playAudio() {
        const { recordDuration } = this.state;
        if (!this.audioBlobMp3) {
            return;
        }
        if (this.audioElement) {
            window?.log?.info('Audio element already init');
        }
        else {
            const audioURL = window.URL.createObjectURL(this.audioBlobMp3);
            this.audioElement = new Audio(audioURL);
            this.audioElement.loop = false;
            this.audioElement.onended = () => {
                this.pauseAudio();
            };
            this.audioElement.oncanplaythrough = async () => {
                const duration = recordDuration;
                if (duration && this.audioElement && this.audioElement.currentTime < duration) {
                    await this.audioElement?.play();
                }
            };
        }
        this.setState({
            isRecording: false,
            isPaused: false,
            isPlaying: true,
        });
        await this.audioElement.play();
    }
    pauseAudio() {
        if (this.audioElement) {
            this.audioElement.pause();
        }
        this.setState({
            isPlaying: false,
            isPaused: true,
        });
    }
    async onDeleteVoiceMessage() {
        this.pauseAudio();
        await this.stopRecordingStream();
        this.audioBlobMp3 = undefined;
        this.audioElement = null;
        this.props.onExitVoiceNoteView();
    }
    async onSendVoiceMessage() {
        if (!this.audioBlobMp3 || !this.audioBlobMp3.size) {
            window?.log?.info('Empty audio blob');
            return;
        }
        if (this.audioBlobMp3.size > constants_1.MAX_ATTACHMENT_FILESIZE_BYTES) {
            utils_1.ToastUtils.pushFileSizeErrorAsByte(constants_1.MAX_ATTACHMENT_FILESIZE_BYTES);
            return;
        }
        void this.props.sendVoiceMessage(this.audioBlobMp3);
    }
    async initiateRecordingStream() {
        if (this.recorder) {
            await this.stopRecordingStream();
        }
        this.recorder = new mic_recorder_to_mp3_1.default({
            bitRate: 128,
        });
        this.recorder
            .start()
            .then(() => {
        })
            .catch((e) => {
            window?.log?.error(e);
        });
    }
    async stopRecordingStream() {
        if (!this.recorder) {
            return;
        }
        window.inboxStore?.dispatch((0, userConfig_1.updateIsCurrentlyRecording)(false));
        const [_, blob] = await this.recorder.stop().getMp3();
        this.recorder = undefined;
        const audioURL = window.URL.createObjectURL(blob);
        const validAudio = new Audio(audioURL);
        if (blob.size < constants_1.DEFAULT_MIN_AUDIO_MEMORY_SIZE) {
            await this.onDeleteVoiceMessage();
            return;
        }
        validAudio.onloadedmetadata = async () => {
            if (validAudio.duration < 1) {
                await this.onDeleteVoiceMessage();
                return;
            }
        };
        this.audioBlobMp3 = blob;
        this.updateAudioElementAndDuration();
        this.stopRecordingState();
    }
    updateAudioElementAndDuration() {
        if (!this.audioBlobMp3) {
            return;
        }
        const audioURL = window.URL.createObjectURL(this.audioBlobMp3);
        this.audioElement = new Audio(audioURL);
        this.setState({
            recordDuration: this.audioElement.duration,
        });
        this.audioElement.loop = false;
        this.audioElement.onended = () => {
            this.pauseAudio();
        };
        this.audioElement.oncanplaythrough = async () => {
            const duration = this.state.recordDuration;
            if (duration && this.audioElement && this.audioElement.currentTime < duration) {
                await this.audioElement?.play();
            }
        };
    }
    async onKeyDown(event) {
        if (event.key === 'Escape') {
            await this.onDeleteVoiceMessage();
        }
    }
}
exports.BchatRecording = BchatRecording;
