"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isLinkedBchatIDWithBnsForDeamon = exports.bnsVerificationConvo = exports.linkBns = exports.setIsBnsHolder = void 0;
const snode_api_1 = require("../../bchat/apis/snode_api");
const ConversationController_1 = require("../../bchat/conversations/ConversationController");
const utils_1 = require("../../bchat/utils");
const bnsConfig_1 = require("../../state/ducks/bnsConfig");
async function setIsBnsHolder(value) {
    const conversation = (0, ConversationController_1.getConversationController)().get(utils_1.UserUtils.getOurPubKeyStrFromCache());
    await conversation.setIsBnsHolder(value);
}
exports.setIsBnsHolder = setIsBnsHolder;
async function linkBns(ourBnsName) {
    window.setLocalValue('ourBnsName', ourBnsName);
    await setIsBnsHolder(true);
}
exports.linkBns = linkBns;
const failureBnsLinkHandler = async () => {
    const i18n = window.i18n;
    window.setLocalValue('ourBnsName', '');
    await setIsBnsHolder(false);
    utils_1.ToastUtils.pushToastError('invalid', i18n('bnsNameAndIDNotMatch'));
    return false;
};
function bnsVerificationConvo(senderConversationModel, isPrivateConversationMessage, envelope) {
    const ourPubkey = utils_1.UserUtils.getOurPubKeyStrFromCache();
    if (senderConversationModel?.attributes?.id === ourPubkey &&
        !window.getLocalValue('ourBnsName') &&
        isPrivateConversationMessage) {
        senderConversationModel.setIsBnsHolder(false);
    }
    else {
        isPrivateConversationMessage && senderConversationModel.setIsBnsHolder(envelope.isBnsHolder);
    }
}
exports.bnsVerificationConvo = bnsVerificationConvo;
async function isLinkedBchatIDWithBnsForDeamon(bnsName) {
    try {
        const i18n = window.i18n;
        const ourBnsName = bnsName || window.getLocalValue('ourBnsName');
        if (!ourBnsName) {
            return false;
        }
        if (!window.navigator.onLine) {
            !!bnsName && utils_1.ToastUtils.pushToastError('invalid', 'Please check your internet connection');
            return false;
        }
        const resolvedBchatID = await snode_api_1.SNodeAPI.getBchatIDForOnsName(ourBnsName);
        const ourNumber = utils_1.UserUtils.getOurPubKeyStrFromCache();
        window.inboxStore?.dispatch((0, bnsConfig_1.setIsVerifyBnsCalled)(true));
        if (ourNumber === resolvedBchatID) {
            !!bnsName && utils_1.ToastUtils.pushToastSuccess('success', i18n('bnsNameverified'));
            return true;
        }
        else {
            return failureBnsLinkHandler();
        }
    }
    catch (error) {
        console.log(error);
        return failureBnsLinkHandler();
    }
}
exports.isLinkedBchatIDWithBnsForDeamon = isLinkedBchatIDWithBnsForDeamon;
