"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConversationHeaderWithDetails = exports.ConversationHeaderSubtitle = exports.StyledSubtitleContainer = exports.SelectionOverlay = void 0;
const react_1 = __importStar(require("react"));
const Avatar_1 = require("../avatar/Avatar");
const react_contexify_1 = require("react-contexify");
const styled_components_1 = __importDefault(require("styled-components"));
const conversation_1 = require("../../models/conversation");
const conversations_1 = require("../../state/selectors/conversations");
const react_redux_1 = require("react-redux");
const unsendingInteractions_1 = require("../../interactions/conversations/unsendingInteractions");
const conversations_2 = require("../../state/ducks/conversations");
const conversationInteractions_1 = require("../../interactions/conversationInteractions");
const call_1 = require("../../state/selectors/call");
const useParamSelector_1 = require("../../hooks/useParamSelector");
const BchatButton_1 = require("../basic/BchatButton");
const icon_1 = require("../icon");
const ConversationHeaderMenu_1 = require("../menu/ConversationHeaderMenu");
const Flex_1 = require("../basic/Flex");
const expiringMessages_1 = require("../../util/expiringMessages");
const Timestamp_1 = require("./Timestamp");
const TypingBubble_1 = require("./TypingBubble");
const conversations_3 = require("../../bchat/conversations");
const walletConfig_1 = require("../../state/selectors/walletConfig");
const settings_key_1 = require("../../data/settings-key");
const modalDialog_1 = require("../../state/ducks/modalDialog");
const theme_1 = require("../../state/selectors/theme");
const data_1 = require("../../data/data");
const SelectionOverlay = () => {
    const selectedMessageIds = (0, react_redux_1.useSelector)(conversations_1.getSelectedMessageIds);
    const selectedConversationKey = (0, react_redux_1.useSelector)(conversations_1.getSelectedConversationKey);
    const isPublic = (0, react_redux_1.useSelector)(conversations_1.getSelectedConversationIsPublic);
    const dispatch = (0, react_redux_1.useDispatch)();
    const darkMode = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark';
    const [canDeleteEveryone, setCanDeleteEveryone] = (0, react_1.useState)(false);
    (0, react_1.useEffect)(() => {
        const isDeleteEveryone = async () => {
            const selectedMessages = await Promise.all(selectedMessageIds.map(id => (0, data_1.getMessageById)(id, false)));
            const compactedMessages = selectedMessages.filter(Boolean);
            const containsIncomingMessages = !isPublic && compactedMessages.some(msg => !msg?.isOutgoing());
            return !containsIncomingMessages;
        };
        isDeleteEveryone().then(result => {
            setCanDeleteEveryone(result);
        });
    }, [selectedMessageIds, isPublic]);
    const { i18n } = window;
    function onCloseOverlay() {
        dispatch((0, conversations_2.resetSelectedMessageIds)());
    }
    function onDeleteSelectedMessages() {
        if (selectedConversationKey) {
            void (0, unsendingInteractions_1.deleteMessagesById)(selectedMessageIds, selectedConversationKey);
        }
    }
    function onDeleteSelectedMessagesForEveryone() {
        if (selectedConversationKey) {
            void (0, unsendingInteractions_1.deleteMessagesByIdForEveryone)(selectedMessageIds, selectedConversationKey);
        }
    }
    const isOnlyServerDeletable = isPublic;
    const deleteMessageButtonText = i18n('deleteJustForMe');
    const deleteForEveryoneMessageButtonText = i18n('deleteForEveryone');
    return (react_1.default.createElement("div", { className: "message-selection-overlay" },
        react_1.default.createElement(Flex_1.Flex, { container: true, alignItems: "center" },
            react_1.default.createElement("div", { className: "close-button" },
                react_1.default.createElement(icon_1.BchatIconButton, { iconType: "xWithCircle", iconSize: 24, onClick: onCloseOverlay })),
            react_1.default.createElement("div", { className: "seleted-count" },
                react_1.default.createElement("span", { style: { marginRight: '5px' } }, selectedMessageIds.length),
                react_1.default.createElement("span", null, "Selected"))),
        react_1.default.createElement("div", { className: "button-group" },
            !isOnlyServerDeletable && (react_1.default.createElement(BchatButton_1.BchatButton, { buttonType: BchatButton_1.BchatButtonType.Medium, buttonColor: BchatButton_1.BchatButtonColor.Danger, text: deleteMessageButtonText, onClick: onDeleteSelectedMessages, style: { borderRadius: '40px', background: darkMode ? '#131313' : '' } })),
            canDeleteEveryone && (react_1.default.createElement(BchatButton_1.BchatButton, { buttonType: BchatButton_1.BchatButtonType.Medium, buttonColor: BchatButton_1.BchatButtonColor.Red, text: deleteForEveryoneMessageButtonText, onClick: onDeleteSelectedMessagesForEveryone, style: { borderRadius: '40px' } })))));
};
exports.SelectionOverlay = SelectionOverlay;
const TripleDotsMenu = (props) => {
    const { showBackButton } = props;
    const isShowing = (0, react_redux_1.useSelector)(conversations_1.isRightPanelShowing);
    if (showBackButton) {
        return null;
    }
    let width = isShowing ? window.innerWidth - 370 : window.innerWidth;
    return (react_1.default.createElement("div", { role: "button", onClick: (e) => {
            react_contexify_1.contextMenu.show({
                id: props.triggerId,
                event: e,
                position: {
                    x: width - 300,
                    y: 70,
                },
            });
        }, "data-testid": "three-dots-conversation-options" },
        react_1.default.createElement(icon_1.BchatIconButton, { iconType: "ellipses", iconSize: 24 })));
};
const ExpirationLength = (props) => {
    const { expirationSettingName } = props;
    if (!expirationSettingName) {
        return null;
    }
    return (react_1.default.createElement("div", { className: "module-conversation-header__expiration" },
        react_1.default.createElement("div", { className: "module-conversation-header__expiration__clock-icon" }),
        react_1.default.createElement("div", { className: "module-conversation-header__expiration__setting", "data-testid": "disappearing-messages-indicator" }, expirationSettingName)));
};
const AvatarHeader = (props) => {
    const { pubkey, onAvatarClick, showBackButton, conversation } = props;
    return (react_1.default.createElement("span", { className: "module-conversation-header__avatar" },
        react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.L, onAvatarClick: () => {
                if (onAvatarClick && !showBackButton) {
                    onAvatarClick(pubkey);
                }
            }, pubkey: pubkey, dataTestId: "conversation-options-avatar", isBnsHolder: conversation?.isBnsHolder })));
};
const BackButton = (props) => {
    const { onGoBack, showBackButton } = props;
    if (!showBackButton) {
        return null;
    }
    return (react_1.default.createElement(icon_1.BchatIconButton, { iconType: "chevron", iconSize: "large", iconRotation: 90, onClick: onGoBack, dataTestId: "back-button-message-details" }));
};
const CallButton = () => {
    const isPrivate = (0, react_redux_1.useSelector)(conversations_1.getIsSelectedPrivate);
    const isBlocked = (0, react_redux_1.useSelector)(conversations_1.getIsSelectedBlocked);
    const isMe = (0, react_redux_1.useSelector)(conversations_1.getIsSelectedNoteToSelf);
    const selectedConvoKey = (0, react_redux_1.useSelector)(conversations_1.getSelectedConversationKey);
    const hasIncomingCall = (0, react_redux_1.useSelector)(call_1.getHasIncomingCall);
    const hasOngoingCall = (0, react_redux_1.useSelector)(call_1.getHasOngoingCall);
    const canCall = !(hasIncomingCall || hasOngoingCall);
    if (!isPrivate || isMe || !selectedConvoKey || isBlocked) {
        return null;
    }
    return (react_1.default.createElement("div", { style: { marginRight: '15px' } },
        react_1.default.createElement(icon_1.BchatIconButton, { iconType: 'call', iconSize: 24, fillRule: "evenodd", clipRule: "evenodd", onClick: () => {
                void (0, conversationInteractions_1.callRecipient)(selectedConvoKey, canCall);
            } })));
};
exports.StyledSubtitleContainer = styled_components_1.default.div `
  display: flex;
  flex-direction: row;
  align-items: center;
  justify-content: center;

  span:last-child {
    margin-bottom: 0;
  }
`;
const ConversationHeaderTitle = () => {
    const headerTitleProps = (0, react_redux_1.useSelector)(conversations_1.getConversationHeaderTitleProps);
    const convoName = (0, useParamSelector_1.useConversationUsername)(headerTitleProps?.conversationKey);
    const convoProps = (0, useParamSelector_1.useConversationPropsById)(headerTitleProps?.conversationKey);
    const conversationKey = (0, react_redux_1.useSelector)(conversations_1.getSelectedConversationKey);
    const conversation = (0, react_redux_1.useSelector)(conversations_1.getSelectedConversation);
    const isShared = (0, react_redux_1.useSelector)(conversations_1.isShareContact);
    let displayedName = null;
    if (conversation?.type === conversation_1.ConversationTypeEnum.PRIVATE) {
        displayedName = (0, conversations_3.getConversationController)().getContactProfileNameOrShortenedPubKey(conversationKey);
    }
    const activeAt = convoProps?.activeAt;
    if (!headerTitleProps) {
        return react_1.default.createElement(react_1.default.Fragment, null);
    }
    const { isGroup, isPublic, members, subscriberCount, isKickedFromGroup } = headerTitleProps;
    const { i18n } = window;
    let memberCount = 0;
    if (isGroup) {
        if (isPublic) {
            memberCount = subscriberCount || 0;
        }
        else {
            memberCount = members.length;
        }
    }
    const SubTxt = styled_components_1.default.div `
    font-size: 11px;
    line-height: 16px;
    letter-spacing: 0.3px;
    // text-transform: uppercase;
    user-select: none;
    font-weight: 100;
    color: var(--color-text-subtle);
  `;
    let memberCountText = '';
    if (isGroup && memberCount > 0 && !isKickedFromGroup) {
        const count = String(memberCount);
        memberCountText = i18n('members', [count]);
    }
    if (conversation?.isMe) {
        return react_1.default.createElement("div", { className: "module-conversation-header__title" }, "Note to Self");
    }
    return (react_1.default.createElement("div", { className: "module-conversation-header__title" },
        react_1.default.createElement("span", { className: "module-contact-name__profile-name", "data-testid": "header-conversation-name", onClick: () => {
                if (isShared) {
                    window.inboxStore?.dispatch((0, conversations_2.closeShareContact)());
                }
                window.inboxStore?.dispatch((0, conversations_2.openRightPanel)());
            }, role: "button" },
            react_1.default.createElement("span", { className: 'receipient_name' }, convoName),
            react_1.default.createElement(SubTxt, null, isGroup ? (memberCountText) : !!conversation.isTyping ? (react_1.default.createElement(TypingBubble_1.TypingBubble, { pubkey: conversationKey, conversationType: conversation?.type, displayedName: displayedName, isTyping: !!conversation.isTyping, key: "typing-bubble" })) : (react_1.default.createElement(Timestamp_1.Timestamp, { timestamp: activeAt, isConversationListItem: true, momentFromNow: true }))))));
};
const ConversationHeaderSubtitle = (props) => {
    const { text } = props;
    if (!text) {
        return null;
    }
    return react_1.default.createElement("span", { className: "module-conversation-header__title-text" }, text);
};
exports.ConversationHeaderSubtitle = ConversationHeaderSubtitle;
const ConversationHeaderWithDetails = () => {
    const isMessageDetailOpened = (0, react_redux_1.useSelector)(conversations_1.isMessageDetailView);
    const selectedConvoKey = (0, react_redux_1.useSelector)(conversations_1.getSelectedConversationKey);
    const conversation = (0, react_redux_1.useSelector)(conversations_1.getSelectedConversation);
    const WalletSyncBarShowInChat = (0, react_redux_1.useSelector)(walletConfig_1.getWalletSyncBarShowInChat);
    const chatwithWallet = window.getSettingValue(settings_key_1.SettingsKey.settingsChatWithWallet) || false;
    const dispatch = (0, react_redux_1.useDispatch)();
    const displayConnectWalletBtn = chatwithWallet &&
        !WalletSyncBarShowInChat &&
        conversation?.type == 'private' &&
        conversation?.isApproved &&
        conversation?.didApproveMe &&
        !conversation?.isMe;
    if (!selectedConvoKey) {
        return null;
    }
    const isKickedFromGroup = (0, useParamSelector_1.useIsKickedFromGroup)(selectedConvoKey);
    const expireTimerSetting = (0, useParamSelector_1.useExpireTimer)(selectedConvoKey);
    const expirationSettingName = expireTimerSetting
        ? expiringMessages_1.ExpirationTimerOptions.getName(expireTimerSetting || 0)
        : undefined;
    const triggerId = 'conversation-header';
    const isMe = (0, react_redux_1.useSelector)(conversations_1.getIsSelectedNoteToSelf);
    const isShared = (0, react_redux_1.useSelector)(conversations_1.isShareContact);
    return (react_1.default.createElement("div", { className: "module-conversation-header" },
        react_1.default.createElement("div", { className: "conversation-header--items-wrapper" },
            react_1.default.createElement(BackButton, { onGoBack: () => {
                    dispatch((0, conversations_2.closeMessageDetailsView)());
                }, showBackButton: isMessageDetailOpened }),
            react_1.default.createElement(ConversationHeaderMenu_1.ConversationHeaderMenu, { triggerId: triggerId }),
            react_1.default.createElement("div", { style: { width: '100%' } },
                react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "row", alignItems: "center" },
                    react_1.default.createElement(AvatarHeader, { onAvatarClick: () => {
                            if (isShared) {
                                window.inboxStore?.dispatch((0, conversations_2.closeShareContact)());
                            }
                            window.inboxStore?.dispatch((0, conversations_2.openRightPanel)());
                        }, pubkey: selectedConvoKey, conversation: conversation, showBackButton: isMessageDetailOpened }),
                    react_1.default.createElement(ConversationHeaderTitle, null),
                    displayConnectWalletBtn && (react_1.default.createElement(BchatButton_1.BchatButton, { text: window.i18n('connectWallet'), buttonType: BchatButton_1.BchatButtonType.Medium, buttonColor: BchatButton_1.BchatButtonColor.Primary, iconType: "wallet", iconSize: 'small', style: {
                            minWidth: '172px',
                            height: '40px',
                            borderRadius: '5px',
                            marginRight: '14px',
                        }, onClick: () => dispatch((0, modalDialog_1.updateBchatWalletPasswordModal)({})) })),
                    !isKickedFromGroup && (react_1.default.createElement(ExpirationLength, { expirationSettingName: expirationSettingName })),
                    conversation?.type == 'private' && conversation?.didApproveMe && !isMe && (react_1.default.createElement("div", null,
                        react_1.default.createElement(CallButton, null))))),
            react_1.default.createElement("div", { className: "module-conversation-header__title-container" },
                react_1.default.createElement("div", { className: "module-conversation-header__title-flex" },
                    react_1.default.createElement(TripleDotsMenu, { triggerId: triggerId, showBackButton: (conversation?.type == 'private' ? !conversation?.didApproveMe : false) || isMessageDetailOpened }))))));
};
exports.ConversationHeaderWithDetails = ConversationHeaderWithDetails;
