"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Emojify = void 0;
const react_1 = __importDefault(require("react"));
const defaultRenderNonEmoji = (text) => react_1.default.createElement(react_1.default.Fragment, null, text || '');
const Emojify = (props) => {
    const { text, renderNonEmoji, sizeClass, isGroup } = props;
    if (!renderNonEmoji) {
        return react_1.default.createElement(react_1.default.Fragment, null, defaultRenderNonEmoji(text));
    }
    const rendered = renderNonEmoji?.({ text: text || '', key: 1, isGroup });
    let size = 1.0;
    switch (sizeClass) {
        case 'jumbo':
            size = 2.0;
            break;
        case 'large':
            size = 1.8;
            break;
        case 'medium':
            size = 1.5;
            break;
        case 'small':
            size = 1.1;
            break;
        case 'default':
            size = 1.0;
            break;
        default:
    }
    return react_1.default.createElement("span", { style: { fontSize: `${size}em`, userSelect: 'inherit' } }, rendered);
};
exports.Emojify = Emojify;
