"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExpireTimer = void 0;
const react_1 = __importStar(require("react"));
const timer_1 = require("../../util/timer");
const useInterval_1 = __importDefault(require("react-use/lib/useInterval"));
const styled_components_1 = __importDefault(require("styled-components"));
const BchatIcon_1 = require("../icon/BchatIcon");
const react_redux_1 = require("react-redux");
const theme_1 = require("../../state/selectors/theme");
const ExpireTimerCount = styled_components_1.default.div `
  width: 60px;
  text-align: center;
  word-break: keep-all;
  margin-inline-end: 10px;
  margin-inline-start: 10px;
  font-size: 14px;
  line-height: 16px;
  letter-spacing: 0.3px;
  text-transform: uppercase;
  user-select: none;
  color: ${props => props.color};
  border-radius: 40px;
  background: ${props => (props.isdark ? '#202329' : '#F8F8F8')};
  padding: 3px 10px;
`;
const ExpireTimerBucket = styled_components_1.default.div `
  margin-inline-end: 10px;
  margin-inline-start: 10px;
  font-size: 11px;
  line-height: 16px;
  letter-spacing: 0.3px;
  text-transform: uppercase;
  user-select: none;
  color: var(--color-text);
`;
const ExpireTimer = (props) => {
    const { expirationLength, expirationTimestamp, isCorrectSide } = props;
    const initialTimeLeft = Math.max(Math.round(((expirationTimestamp || 0) - Date.now()) / 1000), 0);
    const [timeLeft, setTimeLeft] = (0, react_1.useState)(initialTimeLeft);
    const darkMode = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark';
    const update = (0, react_1.useCallback)(() => {
        if (expirationTimestamp) {
            const newTimeLeft = Math.max(Math.round((expirationTimestamp - Date.now()) / 1000), 0);
            if (newTimeLeft !== timeLeft) {
                setTimeLeft(newTimeLeft);
            }
        }
    }, [expirationTimestamp, timeLeft, setTimeLeft]);
    const updateFrequency = 500;
    (0, useInterval_1.default)(update, updateFrequency);
    if (!(isCorrectSide && expirationLength && expirationTimestamp)) {
        return null;
    }
    const expireTimerColor = darkMode ? '#A7A7BA' : '#858598';
    if (timeLeft <= 60) {
        return (react_1.default.createElement(ExpireTimerCount, { color: expireTimerColor, isdark: darkMode }, timeLeft));
    }
    const bucket = (0, timer_1.getTimerBucketIcon)(expirationTimestamp, expirationLength);
    return (react_1.default.createElement(ExpireTimerBucket, null,
        react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: bucket, iconSize: "medium", iconColor: expireTimerColor })));
};
exports.ExpireTimer = ExpireTimer;
