"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AudioPlayerWithEncryptedFile = void 0;
const react_1 = __importStar(require("react"));
const react_h5_audio_player_1 = __importStar(require("react-h5-audio-player"));
const react_redux_1 = require("react-redux");
const useEncryptedFileFetch_1 = require("../../hooks/useEncryptedFileFetch");
const conversations_1 = require("../../state/ducks/conversations");
const conversations_2 = require("../../state/selectors/conversations");
const userConfig_1 = require("../../state/selectors/userConfig");
const BchatButton_1 = require("../basic/BchatButton");
const icon_1 = require("../icon");
const AudioPlayerWithEncryptedFile = (props) => {
    const { messageId, contentType, src } = props;
    const dispatch = (0, react_redux_1.useDispatch)();
    const [playbackSpeed, setPlaybackSpeed] = (0, react_1.useState)(1.0);
    const { urlToLoad } = (0, useEncryptedFileFetch_1.useEncryptedFileFetch)(src, contentType, false);
    const player = (0, react_1.useRef)(null);
    const autoPlaySetting = (0, react_redux_1.useSelector)(userConfig_1.getAudioAutoplay);
    const messageProps = (0, react_redux_1.useSelector)(conversations_2.getSortedMessagesOfSelectedConversation);
    const nextMessageToPlayId = (0, react_redux_1.useSelector)(conversations_2.getNextMessageToPlayId);
    const multiSelectMode = (0, react_redux_1.useSelector)(conversations_2.isMessageSelectionMode);
    (0, react_1.useEffect)(() => {
        if (player.current?.audio.current &&
            player.current?.audio.current?.playbackRate !== playbackSpeed) {
            player.current.audio.current.playbackRate = playbackSpeed;
        }
    }, [playbackSpeed, player]);
    (0, react_1.useEffect)(() => {
        if (messageId !== undefined && messageId === nextMessageToPlayId) {
            player.current?.audio.current?.play();
        }
    }, [messageId, nextMessageToPlayId, player]);
    const triggerPlayNextMessageIfNeeded = (endedMessageId) => {
        const justEndedMessageIndex = messageProps.findIndex(m => m.propsForMessage.id === endedMessageId);
        if (justEndedMessageIndex === -1) {
            dispatch((0, conversations_1.setNextMessageToPlayId)(undefined));
            return;
        }
        const isLastMessage = justEndedMessageIndex === 0;
        if (isLastMessage) {
            dispatch((0, conversations_1.setNextMessageToPlayId)(undefined));
            return;
        }
        const nextMessageIndex = justEndedMessageIndex - 1;
        const prevAuthorNumber = messageProps[justEndedMessageIndex].propsForMessage.sender;
        const nextAuthorNumber = messageProps[nextMessageIndex].propsForMessage.sender;
        const differentAuthor = prevAuthorNumber !== nextAuthorNumber;
        if (differentAuthor) {
            dispatch((0, conversations_1.setNextMessageToPlayId)(undefined));
        }
        else {
            dispatch((0, conversations_1.setNextMessageToPlayId)(messageProps[nextMessageIndex].propsForMessage.id));
        }
    };
    const onEnded = () => {
        if (autoPlaySetting === true && messageId) {
            triggerPlayNextMessageIfNeeded(messageId);
        }
    };
    return (react_1.default.createElement(react_h5_audio_player_1.default, { src: urlToLoad, preload: "metadata", style: { pointerEvents: multiSelectMode ? 'none' : 'inherit' }, layout: "horizontal-reverse", showSkipControls: false, autoPlay: false, autoPlayAfterSrcChange: false, showJumpControls: false, showDownloadProgress: false, listenInterval: 100, onEnded: onEnded, ref: player, customProgressBarSection: [
            react_h5_audio_player_1.RHAP_UI.PROGRESS_BAR,
            react_h5_audio_player_1.RHAP_UI.CURRENT_TIME,
            react_1.default.createElement("div", null, "/"),
            react_h5_audio_player_1.RHAP_UI.DURATION
        ], customControlsSection: [
            react_h5_audio_player_1.RHAP_UI.MAIN_CONTROLS,
            react_1.default.createElement("div", { className: "speedButton", key: "togglePlaybackSpeed" },
                react_1.default.createElement(BchatButton_1.BchatButton, { text: `${playbackSpeed}x`, onClick: () => {
                        setPlaybackSpeed(playbackSpeed === 1 ? 1.5 : 1);
                    }, buttonType: BchatButton_1.BchatButtonType.Simple, buttonColor: BchatButton_1.BchatButtonColor.None })),
        ], customIcons: {
            play: (react_1.default.createElement(icon_1.BchatIcon, { iconType: "play", iconSize: "small", iconColor: 'var(--color-text-subtle)' })),
            pause: (react_1.default.createElement(icon_1.BchatIcon, { iconType: "pause", iconSize: "small", iconColor: 'var(--color-text-subtle)' })),
        } }));
};
exports.AudioPlayerWithEncryptedFile = AudioPlayerWithEncryptedFile;
