"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Image = void 0;
const react_1 = __importStar(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const Spinner_1 = require("../basic/Spinner");
const useEncryptedFileFetch_1 = require("../../hooks/useEncryptedFileFetch");
const useDisableDrag_1 = require("../../hooks/useDisableDrag");
const icon_1 = require("../icon");
const Image = (props) => {
    const { alt, attachment, bottomOverlay, closeButton, darkOverlay, height, onClick, onClickClose, onError, overlayText, playIconOverlay, softCorners, forceSquare, attachmentIndex, url, width, } = props;
    const onErrorUrlFilterering = (0, react_1.useCallback)(() => {
        if (url && onError) {
            onError();
        }
        return;
    }, [url, onError]);
    const disableDrag = (0, useDisableDrag_1.useDisableDrag)();
    const { caption } = attachment || { caption: null };
    let { pending } = attachment || { pending: true };
    if (!url) {
        pending = true;
    }
    const canClick = onClick && !pending;
    const role = canClick ? 'button' : undefined;
    const { loading, urlToLoad } = (0, useEncryptedFileFetch_1.useEncryptedFileFetch)(url || '', attachment.contentType, false);
    const srcData = !loading ? urlToLoad : '';
    return (react_1.default.createElement("div", { role: role, onClick: (e) => {
            if (canClick && onClick) {
                e.stopPropagation();
                onClick(attachment);
            }
        }, className: (0, classnames_1.default)('module-image', canClick ? 'module-image__with-click-handler' : null, softCorners ? 'module-image--soft-corners' : null), style: {
            maxHeight: `${height}px`,
            maxWidth: `${width}px`,
        }, "data-attachmentindex": attachmentIndex },
        pending || loading ? (react_1.default.createElement("div", { className: "module-image__loading-placeholder", style: {
                maxHeight: `${height}px`,
                maxWidth: `${width}px`,
                width: `${width}px`,
                height: `${height}px`,
                lineHeight: `${height}px`,
                textAlign: 'center',
            } },
            react_1.default.createElement(Spinner_1.Spinner, { size: "normal" }))) : (react_1.default.createElement("img", { onError: onErrorUrlFilterering, className: (0, classnames_1.default)('module-image__image', forceSquare ? 'module-image__image-cover' : ''), alt: alt, style: {
                maxHeight: `${height}px`,
                maxWidth: `${width}px`,
                width: forceSquare ? `${width}px` : '',
                height: forceSquare ? `${height}px` : '',
            }, src: srcData, onDragStart: disableDrag })),
        caption ? (react_1.default.createElement("img", { className: "module-image__caption-icon", src: "images/caption-shadow.svg", alt: window.i18n('imageCaptionIconAlt'), onDragStart: disableDrag })) : null,
        react_1.default.createElement("div", { className: (0, classnames_1.default)('module-image__border-overlay', softCorners ? 'module-image--soft-corners' : null, darkOverlay ? 'module-image__border-overlay--dark' : null) }),
        closeButton ? (react_1.default.createElement("div", { className: "module-image__close-button", onClick: (e) => {
                e.stopPropagation();
                if (onClickClose) {
                    onClickClose(attachment);
                }
            } },
            react_1.default.createElement(icon_1.BchatIcon, { iconType: 'xWithCircle', iconSize: 16, iconColor: "#fff" }))) :
            null,
        bottomOverlay ? react_1.default.createElement("div", { className: (0, classnames_1.default)('module-image__bottom-overlay') }) : null,
        !(pending || loading) && playIconOverlay ? (react_1.default.createElement("div", { className: "module-image__play-overlay__circle" },
            react_1.default.createElement("div", { className: "module-image__play-overlay__icon" }))) : null,
        overlayText ? (react_1.default.createElement("div", { className: "module-image__text-container", style: { lineHeight: `${height}px` } }, overlayText)) : null));
};
exports.Image = Image;
