"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImageGrid = void 0;
const react_1 = __importStar(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const Attachment_1 = require("../../types/Attachment");
const Image_1 = require("./Image");
const MessageContent_1 = require("./message/message-content/MessageContent");
const ImageGrid = (props) => {
    const { attachments, bottomOverlay, onError, onClickAttachment } = props;
    const isMessageVisible = (0, react_1.useContext)(MessageContent_1.IsMessageVisibleContext);
    const withBottomOverlay = Boolean(bottomOverlay);
    if (!attachments || !attachments.length) {
        return null;
    }
    if (attachments.length === 1 || !(0, Attachment_1.areAllAttachmentsVisual)(attachments)) {
        const { height, width } = (0, Attachment_1.getImageDimensionsInAttachment)(attachments[0]);
        const finalUrl = isMessageVisible && attachments[0].contentType === 'image/gif'
            ? attachments[0]?.url
            : isMessageVisible
                ? (0, Attachment_1.getThumbnailUrl)(attachments[0])
                : undefined;
        return (react_1.default.createElement("div", { className: (0, classnames_1.default)('module-image-grid', 'module-image-grid--one-image') },
            react_1.default.createElement(Image_1.Image, { alt: (0, Attachment_1.getAlt)(attachments[0]), bottomOverlay: withBottomOverlay, attachment: attachments[0], playIconOverlay: (0, Attachment_1.isVideoAttachment)(attachments[0]), height: height, width: width, url: finalUrl, onClick: onClickAttachment, onError: onError, attachmentIndex: 0 })));
    }
    if (attachments.length === 2) {
        return (react_1.default.createElement("div", { className: "module-image-grid" },
            react_1.default.createElement(Image_1.Image, { alt: (0, Attachment_1.getAlt)(attachments[0]), attachment: attachments[0], bottomOverlay: withBottomOverlay, playIconOverlay: (0, Attachment_1.isVideoAttachment)(attachments[0]), height: 149, width: 149, url: isMessageVisible ? (0, Attachment_1.getThumbnailUrl)(attachments[0]) : undefined, onClick: onClickAttachment, onError: onError, attachmentIndex: 0 }),
            react_1.default.createElement(Image_1.Image, { alt: (0, Attachment_1.getAlt)(attachments[1]), bottomOverlay: withBottomOverlay, playIconOverlay: (0, Attachment_1.isVideoAttachment)(attachments[1]), height: 149, width: 149, attachment: attachments[1], url: isMessageVisible ? (0, Attachment_1.getThumbnailUrl)(attachments[1]) : undefined, onClick: onClickAttachment, onError: onError, attachmentIndex: 1 })));
    }
    if (attachments.length === 3) {
        return (react_1.default.createElement("div", { className: "module-image-grid" },
            react_1.default.createElement(Image_1.Image, { alt: (0, Attachment_1.getAlt)(attachments[0]), bottomOverlay: withBottomOverlay, attachment: attachments[0], playIconOverlay: (0, Attachment_1.isVideoAttachment)(attachments[0]), height: 200, width: 199, url: isMessageVisible ? (0, Attachment_1.getThumbnailUrl)(attachments[0]) : undefined, onClick: onClickAttachment, onError: onError, attachmentIndex: 0 }),
            react_1.default.createElement("div", { className: "module-image-grid__column" },
                react_1.default.createElement(Image_1.Image, { alt: (0, Attachment_1.getAlt)(attachments[1]), height: 99, width: 99, attachment: attachments[1], playIconOverlay: (0, Attachment_1.isVideoAttachment)(attachments[1]), url: isMessageVisible ? (0, Attachment_1.getThumbnailUrl)(attachments[1]) : undefined, onClick: onClickAttachment, onError: onError, attachmentIndex: 1 }),
                react_1.default.createElement(Image_1.Image, { alt: (0, Attachment_1.getAlt)(attachments[2]), bottomOverlay: withBottomOverlay, height: 99, width: 99, attachment: attachments[2], playIconOverlay: (0, Attachment_1.isVideoAttachment)(attachments[2]), url: isMessageVisible ? (0, Attachment_1.getThumbnailUrl)(attachments[2]) : undefined, onClick: onClickAttachment, onError: onError, attachmentIndex: 2 }))));
    }
    if (attachments.length === 4) {
        return (react_1.default.createElement("div", { className: "module-image-grid" },
            react_1.default.createElement("div", { className: "module-image-grid__column" },
                react_1.default.createElement("div", { className: "module-image-grid__row" },
                    react_1.default.createElement(Image_1.Image, { alt: (0, Attachment_1.getAlt)(attachments[0]), attachment: attachments[0], playIconOverlay: (0, Attachment_1.isVideoAttachment)(attachments[0]), height: 149, width: 149, url: isMessageVisible ? (0, Attachment_1.getThumbnailUrl)(attachments[0]) : undefined, onClick: onClickAttachment, onError: onError, attachmentIndex: 0 }),
                    react_1.default.createElement(Image_1.Image, { alt: (0, Attachment_1.getAlt)(attachments[1]), playIconOverlay: (0, Attachment_1.isVideoAttachment)(attachments[1]), height: 149, width: 149, attachment: attachments[1], url: isMessageVisible ? (0, Attachment_1.getThumbnailUrl)(attachments[1]) : undefined, onClick: onClickAttachment, onError: onError, attachmentIndex: 1 })),
                react_1.default.createElement("div", { className: "module-image-grid__row" },
                    react_1.default.createElement(Image_1.Image, { alt: (0, Attachment_1.getAlt)(attachments[2]), bottomOverlay: withBottomOverlay, playIconOverlay: (0, Attachment_1.isVideoAttachment)(attachments[2]), height: 149, width: 149, attachment: attachments[2], url: isMessageVisible ? (0, Attachment_1.getThumbnailUrl)(attachments[2]) : undefined, onClick: onClickAttachment, onError: onError, attachmentIndex: 2 }),
                    react_1.default.createElement(Image_1.Image, { alt: (0, Attachment_1.getAlt)(attachments[3]), bottomOverlay: withBottomOverlay, playIconOverlay: (0, Attachment_1.isVideoAttachment)(attachments[3]), height: 149, width: 149, attachment: attachments[3], url: isMessageVisible ? (0, Attachment_1.getThumbnailUrl)(attachments[3]) : undefined, onClick: onClickAttachment, onError: onError, attachmentIndex: 3 })))));
    }
    const moreMessagesOverlay = attachments.length > 5;
    const moreMessagesOverlayText = moreMessagesOverlay ? `+${attachments.length - 5}` : undefined;
    return (react_1.default.createElement("div", { className: "module-image-grid" },
        react_1.default.createElement("div", { className: "module-image-grid__column" },
            react_1.default.createElement("div", { className: "module-image-grid__row" },
                react_1.default.createElement(Image_1.Image, { alt: (0, Attachment_1.getAlt)(attachments[0]), attachment: attachments[0], playIconOverlay: (0, Attachment_1.isVideoAttachment)(attachments[0]), height: 149, width: 149, url: isMessageVisible ? (0, Attachment_1.getThumbnailUrl)(attachments[0]) : undefined, onClick: onClickAttachment, onError: onError, attachmentIndex: 0 }),
                react_1.default.createElement(Image_1.Image, { alt: (0, Attachment_1.getAlt)(attachments[1]), playIconOverlay: (0, Attachment_1.isVideoAttachment)(attachments[1]), height: 149, width: 149, attachment: attachments[1], url: isMessageVisible ? (0, Attachment_1.getThumbnailUrl)(attachments[1]) : undefined, onClick: onClickAttachment, onError: onError, attachmentIndex: 1 })),
            react_1.default.createElement("div", { className: "module-image-grid__row" },
                react_1.default.createElement(Image_1.Image, { alt: (0, Attachment_1.getAlt)(attachments[2]), bottomOverlay: withBottomOverlay, playIconOverlay: (0, Attachment_1.isVideoAttachment)(attachments[2]), height: 99, width: 99, attachment: attachments[2], url: isMessageVisible ? (0, Attachment_1.getThumbnailUrl)(attachments[2]) : undefined, onClick: onClickAttachment, onError: onError, attachmentIndex: 2 }),
                react_1.default.createElement(Image_1.Image, { alt: (0, Attachment_1.getAlt)(attachments[3]), bottomOverlay: withBottomOverlay, playIconOverlay: (0, Attachment_1.isVideoAttachment)(attachments[3]), height: 99, width: 98, attachment: attachments[3], url: isMessageVisible ? (0, Attachment_1.getThumbnailUrl)(attachments[3]) : undefined, onClick: onClickAttachment, onError: onError, attachmentIndex: 3 }),
                react_1.default.createElement(Image_1.Image, { alt: (0, Attachment_1.getAlt)(attachments[4]), bottomOverlay: withBottomOverlay, playIconOverlay: (0, Attachment_1.isVideoAttachment)(attachments[4]), height: 99, width: 99, darkOverlay: moreMessagesOverlay, overlayText: moreMessagesOverlayText, attachment: attachments[4], url: isMessageVisible ? (0, Attachment_1.getThumbnailUrl)(attachments[4]) : undefined, onClick: onClickAttachment, onError: onError, attachmentIndex: 4 })))));
};
exports.ImageGrid = ImageGrid;
