"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StagedAttachmentList = void 0;
const react_1 = __importDefault(require("react"));
const GoogleChrome_1 = require("../../util/GoogleChrome");
const Image_1 = require("./Image");
const StagedGenericAttachment_1 = require("./StagedGenericAttachment");
const StagedPlaceholderAttachment_1 = require("./StagedPlaceholderAttachment");
const Attachment_1 = require("../../types/Attachment");
const react_redux_1 = require("react-redux");
const stagedAttachments_1 = require("../../state/ducks/stagedAttachments");
const conversations_1 = require("../../state/selectors/conversations");
const theme_1 = require("../../state/selectors/theme");
const IMAGE_WIDTH = 100;
const IMAGE_HEIGHT = 120;
const StagedAttachmentList = (props) => {
    const { attachments, onAddAttachment, onClickAttachment } = props;
    const darkMode = (0, react_redux_1.useSelector)(theme_1.getTheme) === 'dark';
    const dispatch = (0, react_redux_1.useDispatch)();
    const conversationKey = (0, react_redux_1.useSelector)(conversations_1.getSelectedConversationKey);
    const onRemoveByFilename = (filename) => {
        if (!conversationKey) {
            return;
        }
        dispatch((0, stagedAttachments_1.removeStagedAttachmentInConversation)({ conversationKey, filename }));
    };
    if (!attachments.length) {
        return null;
    }
    const allVisualAttachments = (0, Attachment_1.areAllAttachmentsVisual)(attachments);
    return (react_1.default.createElement("div", { className: "module-attachments" },
        react_1.default.createElement("div", { className: "module-attachments__rail" },
            react_1.default.createElement("div", { className: 'module-inner-img-wrapper' }, (attachments || []).map((attachment, index) => {
                const { contentType } = attachment;
                if ((0, GoogleChrome_1.isImageTypeSupported)(contentType) || (0, GoogleChrome_1.isVideoTypeSupported)(contentType)) {
                    const imageKey = (0, Attachment_1.getUrl)(attachment) || attachment.fileName || index;
                    const clickCallback = attachments.length > 1 ? onClickAttachment : undefined;
                    return (react_1.default.createElement(Image_1.Image, { key: imageKey, alt: window.i18n('stagedImageAttachment', [attachment.fileName]), attachment: attachment, softCorners: true, playIconOverlay: (0, Attachment_1.isVideoAttachment)(attachment), height: IMAGE_HEIGHT, width: IMAGE_WIDTH, forceSquare: true, url: (0, Attachment_1.getUrl)(attachment), closeButton: true, onClick: clickCallback, onClickClose: () => {
                            onRemoveByFilename(attachment.fileName);
                        } }));
                }
                const genericKey = (0, Attachment_1.getUrl)(attachment) || attachment.fileName || index;
                return (react_1.default.createElement(StagedGenericAttachment_1.StagedGenericAttachment, { key: genericKey, attachment: attachment, onClose: () => {
                        onRemoveByFilename(attachment.fileName);
                    } }));
            })),
            allVisualAttachments ? react_1.default.createElement(StagedPlaceholderAttachment_1.StagedPlaceholderAttachment, { onClick: onAddAttachment, darkMode: darkMode }) : null)));
};
exports.StagedAttachmentList = StagedAttachmentList;
