"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StagedLinkPreview = void 0;
const react_1 = __importDefault(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const Image_1 = require("./Image");
const BchatSpinner_1 = require("../basic/BchatSpinner");
const MIME_1 = require("../../types/MIME");
const String_1 = require("../../bchat/utils/String");
const icon_1 = require("../icon");
const StagedLinkPreview = (props) => {
    const { isLoaded, onClose, title, image, domain, url } = props;
    const isContentTypeImage = image && (0, MIME_1.isImage)(image.contentType);
    if (isLoaded && !(title && domain)) {
        return null;
    }
    const isLoading = !isLoaded;
    const dataToRender = image?.data
        ? `data:image/jpeg;base64, ${(0, String_1.fromArrayBufferToBase64)(image?.data)}`
        : '';
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)('module-staged-link-preview', isLoading ? 'module-staged-link-preview--is-loading' : null) },
        isLoading ? react_1.default.createElement(BchatSpinner_1.BchatSpinner, { loading: isLoading }) : null,
        isLoaded && image && isContentTypeImage ? (react_1.default.createElement("div", { className: "module-staged-link-preview__icon-container" },
            react_1.default.createElement(Image_1.Image, { alt: window.i18n('stagedPreviewThumbnail', [domain || '']), softCorners: true, height: 72, width: 72, url: dataToRender, attachment: image }))) : null,
        isLoaded ? (react_1.default.createElement("div", { className: "module-staged-link-preview__content" },
            react_1.default.createElement("div", { className: "module-staged-link-preview__title" }, title),
            react_1.default.createElement("div", { className: "module-staged-link-preview__footer" },
                react_1.default.createElement("div", { className: "module-staged-link-preview__location" }, domain)))) : null,
        react_1.default.createElement("button", { type: "button", className: "module-staged-link-preview__close-button", onClick: () => {
                onClose(url || '');
            }, "aria-label": window.i18n('close') },
            react_1.default.createElement(icon_1.BchatIcon, { iconType: 'xWithCircle', iconSize: 24 }))));
};
exports.StagedLinkPreview = StagedLinkPreview;
