"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimerNotification = void 0;
const react_1 = __importDefault(require("react"));
const missingCaseError_1 = require("../../util/missingCaseError");
const NotificationBubble_1 = require("./message/message-item/notification-bubble/NotificationBubble");
const ReadableMessage_1 = require("./message/message-item/ReadableMessage");
const TimerNotification = (props) => {
    const { messageId, receivedAt, isUnread, pubkey, profileName, timespan, type, disabled } = props;
    const contact = profileName || pubkey;
    let textToRender;
    switch (type) {
        case 'fromOther':
            textToRender = disabled
                ? window.i18n('disabledDisappearingMessages', [contact, timespan])
                : window.i18n('theyChangedTheTimer', [contact, timespan]);
            break;
        case 'fromMe':
            textToRender = disabled
                ? window.i18n('youDisabledDisappearingMessages')
                : window.i18n('youChangedTheTimer', [timespan]);
            break;
        case 'fromSync':
            textToRender = disabled
                ? window.i18n('disappearingMessagesDisabled')
                : window.i18n('timerSetOnSync', [timespan]);
            break;
        default:
            throw (0, missingCaseError_1.missingCaseError)(type);
    }
    if (!textToRender || textToRender.length === 0) {
        throw new Error('textToRender invalid key used TimerNotification');
    }
    return (react_1.default.createElement(ReadableMessage_1.ReadableMessage, { messageId: messageId, receivedAt: receivedAt, isUnread: isUnread, key: `readable-message-${messageId}` },
        react_1.default.createElement(NotificationBubble_1.NotificationBubble, { iconType: "stopwatch", iconColor: "inherit", notificationText: textToRender })));
};
exports.TimerNotification = TimerNotification;
