"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Timestamp = void 0;
const react_1 = __importStar(require("react"));
const moment_1 = __importDefault(require("moment"));
const useInterval_1 = __importDefault(require("react-use/lib/useInterval"));
const styled_components_1 = __importDefault(require("styled-components"));
const UPDATE_FREQUENCY = 60 * 1000;
const TimestampContainerNotListItem = styled_components_1.default.div `
  font-size: 11px;
  line-height: 16px;
  letter-spacing: 0.3px;
  // text-transform: uppercase;
  user-select: none;
  color: var(--color-text-subtle);
  position: relative;
  
`;
const TimestampContainerListItem = (0, styled_components_1.default)(TimestampContainerNotListItem) `
  flex-shrink: 0;
  margin-inline-start: 0px;
  overflow-x: hidden;
  white-space: nowrap;
  text-overflow: ellipsis;
`;
const Timestamp = (props) => {
    const [_lastUpdated, setLastUpdated] = (0, react_1.useState)(Date.now());
    const update = (0, react_1.useCallback)(() => {
        setLastUpdated(Date.now());
    }, [setLastUpdated]);
    (0, useInterval_1.default)(update, UPDATE_FREQUENCY);
    const { timestamp, momentFromNow } = props;
    if (timestamp === null || timestamp === undefined || timestamp === 0) {
        return null;
    }
    const momentValue = (0, moment_1.default)(timestamp);
    let dateString = '';
    if (momentFromNow) {
        dateString = momentValue.fromNow();
    }
    else {
        dateString = momentValue.format('lll');
    }
    dateString = dateString.replace('minutes', 'mins').replace('minute', 'min');
    const title = (0, moment_1.default)(timestamp).format('llll');
    if (props.isConversationListItem) {
        return react_1.default.createElement(TimestampContainerListItem, { title: title }, dateString);
    }
    return react_1.default.createElement(TimestampContainerNotListItem, { title: title }, dateString);
};
exports.Timestamp = Timestamp;
