"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importStar(require("react"));
const WaveformBars = ({ peaks, progress, barWidth = 2, gap = 2, minPeakHeight = 0.09, progressColor = '#2F8FFF', waveColor = '#16191F', isDragging = false, onMouseDown, onMouseMove, onMouseUp, onMouseLeave, }) => {
    const totalBars = (0, react_1.useMemo)(() => Math.floor(300 / (barWidth + gap)), [barWidth, gap]);
    const step = (0, react_1.useMemo)(() => Math.max(1, Math.floor(peaks.length / totalBars)), [peaks, totalBars]);
    const bars = (0, react_1.useMemo)(() => {
        return Array.from({ length: totalBars }, (_, i) => {
            const peak = peaks[i * step] || 0;
            const validPeak = Math.max(peak, minPeakHeight);
            return {
                height: validPeak,
            };
        });
    }, [peaks, step, totalBars, minPeakHeight]);
    const progressBars = Math.floor(bars.length * progress);
    const preventCursorDisable = progressBars >= totalBars - 1
        ? progressBars - 1.2
        : progressBars <= 0
            ? 1.2
            : progressBars + 1.2;
    const cursorX = preventCursorDisable * (barWidth + gap);
    return (react_1.default.createElement("div", { className: "waveform-container", onMouseDown: onMouseDown, onMouseMove: onMouseMove, onMouseUp: onMouseUp, onMouseLeave: onMouseLeave },
        bars.map((bar, index) => {
            const isHighlighted = progressBars > 0 && index <= progressBars;
            return (react_1.default.createElement("div", { key: index, className: "waveform-bar", style: {
                    height: `${bar.height * 100}%`,
                    backgroundColor: isHighlighted ? progressColor : waveColor,
                    width: `${barWidth}px`,
                    marginRight: `${gap}px`,
                } }));
        }),
        react_1.default.createElement("div", { className: "waveform-cursor", style: {
                left: `${cursorX}px`,
                transform: 'translateX(-50%)',
                width: isDragging ? 16 : 10,
                height: isDragging ? 16 : 10,
                marginTop: isDragging ? '-8px' : '-5px'
            } })));
};
exports.default = WaveformBars;
