"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompositionBox = void 0;
const react_1 = __importDefault(require("react"));
const lodash_1 = __importStar(require("lodash"));
const MIME = __importStar(require("../../../types/MIME"));
const BchatEmojiPanel_1 = require("../BchatEmojiPanel");
const BchatRecording_1 = require("../BchatRecording");
const react_circular_progressbar_1 = require("react-circular-progressbar");
const BchatStagedLinkPreview_1 = require("../BchatStagedLinkPreview");
const abort_controller_1 = require("abort-controller");
const BchatQuotedMessageComposition_1 = require("../BchatQuotedMessageComposition");
const react_mentions_1 = require("react-mentions");
const auto_bind_1 = __importDefault(require("auto-bind"));
const BchatSettings_1 = require("../../settings/BchatSettings");
const BchatConversationDrafts_1 = require("../BchatConversationDrafts");
const CompositionButtons_1 = require("./CompositionButtons");
const react_redux_1 = require("react-redux");
const conversationInteractions_1 = require("../../../interactions/conversationInteractions");
const conversations_1 = require("../../../bchat/conversations");
const utils_1 = require("../../../bchat/utils");
const conversations_2 = require("../../../state/ducks/conversations");
const stagedAttachments_1 = require("../../../state/ducks/stagedAttachments");
const conversations_3 = require("../../../state/selectors/conversations");
const util_1 = require("../../../util");
const Flex_1 = require("../../basic/Flex");
const CaptionEditor_1 = require("../../CaptionEditor");
const StagedAttachmentList_1 = require("../StagedAttachmentList");
const MessageAttachment_1 = require("../../../types/MessageAttachment");
const UserMentions_1 = require("./UserMentions");
const EmojiQuickResult_1 = require("./EmojiQuickResult");
const linkPreviews_1 = require("../../../util/linkPreviews");
const settings_key_1 = require("../../../data/settings-key");
const modalDialog_1 = require("../../../state/ducks/modalDialog");
const section_1 = require("../../../state/ducks/section");
const BchatButton_1 = require("../../basic/BchatButton");
const walletConfig_1 = require("../../../state/selectors/walletConfig");
const wallet_rpc_1 = require("../../../wallet/wallet-rpc");
const data_1 = require("../../../data/data");
const conversation_1 = require("../../../models/conversation");
const Toast_1 = require("../../../bchat/utils/Toast");
const walletConfig_2 = require("../../../state/ducks/walletConfig");
const modal_1 = require("../../../state/selectors/modal");
const BchatIcon_1 = require("../../icon/BchatIcon");
const daemon_1 = require("../../../state/selectors/daemon");
const ChangingProgressProvider_1 = __importDefault(require("../../basic/ChangingProgressProvider"));
const classnames_1 = __importDefault(require("classnames"));
const Text_1 = require("../../basic/Text");
const BeldexCoinLogo_1 = __importDefault(require("../../icon/BeldexCoinLogo"));
const styled_components_1 = __importDefault(require("styled-components"));
const userConfig_1 = require("../../../state/ducks/userConfig");
const MediaFileIcon_1 = __importDefault(require("../../icon/MediaFileIcon"));
const ContactsIcon_1 = __importDefault(require("../../icon/ContactsIcon"));
const sendMessageStyle = {
    control: {},
    input: {
        overflow: 'auto',
        maxHeight: '300px',
        wordBreak: 'break-word',
        padding: '0',
        margin: '0px',
    },
    highlighter: {
        boxSizing: 'border-box',
        overflow: 'hidden',
        maxHeight: '300px',
    },
    flexGrow: 1,
    maxHeight: '300px',
    width: '100%',
    ...UserMentions_1.styleForCompositionBoxSuggestions,
};
const getDefaultState = (newConvoId) => {
    return {
        draft: (0, BchatConversationDrafts_1.getDraftForConversation)(newConvoId),
        showRecordingView: false,
        showEmojiPanel: false,
        ignoredLink: undefined,
        stagedLinkPreview: undefined,
        showCaptionEditor: undefined,
        selectionMenuIsVisble: false,
    };
};
const getSelectionBasedOnMentions = (draft, index) => {
    const matches = draft.match(UserMentions_1.mentionsRegex);
    let lastMatchStartIndex = 0;
    let lastMatchEndIndex = 0;
    let lastRealMatchEndIndex = 0;
    if (!matches) {
        return index;
    }
    const mapStartToLengthOfMatches = matches.map(match => {
        const displayNameStart = match.indexOf('\uFFD7') + 1;
        const displayNameEnd = match.lastIndexOf('\uFFD2');
        const displayName = match.substring(displayNameStart, displayNameEnd);
        const currentMatchStartIndex = draft.indexOf(match) + lastMatchStartIndex;
        lastMatchStartIndex = currentMatchStartIndex;
        lastMatchEndIndex = currentMatchStartIndex + match.length;
        const realLength = displayName.length + 1;
        lastRealMatchEndIndex = lastRealMatchEndIndex + realLength;
        return {
            length: displayName.length + 1,
            lastRealMatchEndIndex,
            start: lastMatchStartIndex,
            end: lastMatchEndIndex,
        };
    });
    const beforeFirstMatch = index < mapStartToLengthOfMatches[0].start;
    if (beforeFirstMatch) {
        return index;
    }
    const lastMatchMap = lodash_1.default.last(mapStartToLengthOfMatches);
    if (!lastMatchMap) {
        return Number.MAX_SAFE_INTEGER;
    }
    const indexIsAfterEndOfLastMatch = lastMatchMap.lastRealMatchEndIndex <= index;
    if (indexIsAfterEndOfLastMatch) {
        const lastEnd = lastMatchMap.end;
        const diffBetweenEndAndLastRealEnd = index - lastMatchMap.lastRealMatchEndIndex;
        return lastEnd + diffBetweenEndAndLastRealEnd - 1;
    }
    return Number.MAX_SAFE_INTEGER;
};
const StyledEmojiPanelContainer = styled_components_1.default.div `
  ${BchatEmojiPanel_1.StyledEmojiPanel} {
    position: absolute;
    bottom: 68px;
    right: 0px;
  }
`;
class CompositionBoxInner extends react_1.default.Component {
    textarea;
    fileInput;
    emojiPanel;
    emojiPanelButton;
    linkPreviewAbortController;
    container;
    lastBumpTypingMessageLength = 0;
    chatwithWallet;
    constructor(props) {
        super(props);
        this.state = getDefaultState();
        this.textarea = react_1.default.createRef();
        this.fileInput = react_1.default.createRef();
        this.container = null;
        this.emojiPanel = react_1.default.createRef();
        this.emojiPanelButton = react_1.default.createRef();
        (0, auto_bind_1.default)(this);
        this.toggleEmojiPanel = (0, lodash_1.debounce)(this.toggleEmojiPanel.bind(this), 100);
        this.chatwithWallet = window.getSettingValue(settings_key_1.SettingsKey.settingsChatWithWallet) || false;
    }
    componentDidMount() {
        setTimeout(this.focusCompositionBox, 500);
        const div = this.container;
        div?.addEventListener('paste', this.handlePaste);
    }
    componentWillUnmount() {
        this.linkPreviewAbortController?.abort();
        this.linkPreviewAbortController = undefined;
        const div = this.container;
        div?.removeEventListener('paste', this.handlePaste);
    }
    sendAmountValidation() {
        const { selectedConversation, WalletSyncBarShowInChat, isMe } = this.props;
        const { draft } = this.state;
        const getSyncStatus = window.getSettingValue('syncStatus');
        const re = /^\d+(\.\d{1,5})?$/;
        const results = selectedConversation?.type === 'private' &&
            re.test(draft) &&
            Number(draft) >= 0.00001 &&
            selectedConversation?.isApproved &&
            selectedConversation?.didApproveMe &&
            !selectedConversation?.isBlocked &&
            this.chatwithWallet &&
            WalletSyncBarShowInChat &&
            !isMe &&
            getSyncStatus &&
            draft.length <= 16;
        return results;
    }
    chatWithWalletInstruction() {
        const { WalletSyncBarShowInChat } = this.props;
        if (!this.chatwithWallet && !WalletSyncBarShowInChat) {
            window.inboxStore?.dispatch((0, modalDialog_1.updateBchatAlertConfirmModal)({
                onClickOk: async () => {
                    window.inboxStore?.dispatch((0, modalDialog_1.updateBchatAlertConfirmModal)(null));
                    window.inboxStore?.dispatch((0, section_1.showLeftPaneSection)(section_1.SectionType.Settings));
                    window.inboxStore?.dispatch((0, section_1.setOverlayMode)(undefined));
                },
                onClickCancel: () => window.inboxStore?.dispatch((0, modalDialog_1.updateBchatAlertConfirmModal)(null)),
            }));
        }
    }
    sendConfirmModal() {
        const messagePlaintext = (0, UserMentions_1.cleanMentions)(this.state.draft);
        const priority = window.getSettingValue(settings_key_1.walletSettingsKey.settingsPriority) || 'Flash';
        if (!this.props.selectedConversation?.walletAddress) {
            return (0, Toast_1.pushToastError)('', 'To send & receive BDX in-chat, start a conversation with your friend first.');
        }
        window.inboxStore?.dispatch((0, modalDialog_1.updateSendConfirmModal)({
            okTheme: BchatButton_1.BchatButtonColor.Green,
            address: this.props.selectedConversation?.walletAddress,
            amount: messagePlaintext,
            fee: priority === 'Flash' ? 0.0291 : 0.0096,
            Priority: priority,
            onClickOk: async () => {
                await this.sendFund();
            },
            onClickClose: () => {
                window.inboxStore?.dispatch((0, modalDialog_1.updateSendConfirmModal)(null));
            },
        }));
    }
    sendFund = async () => {
        const draft = this.state.draft;
        const priority = window.getSettingValue(settings_key_1.walletSettingsKey.settingsPriority) || 'Flash';
        if (draft == 0) {
            window.inboxStore?.dispatch((0, modalDialog_1.updateSendConfirmModal)(null));
            window.inboxStore?.dispatch((0, modalDialog_1.updateTransactionInitModal)(null));
            return utils_1.ToastUtils.pushToastError('zeroAmount', 'Amount must be greater than zero');
        }
        if (draft > this.props.walletDetails.unlocked_balance / 1e9) {
            window.inboxStore?.dispatch((0, modalDialog_1.updateSendConfirmModal)(null));
            window.inboxStore?.dispatch((0, modalDialog_1.updateTransactionInitModal)(null));
            return window.inboxStore?.dispatch((0, modalDialog_1.updateInsufficientBalanceModal)(true));
        }
        let decimalValue = window.getSettingValue(settings_key_1.walletSettingsKey.settingsDecimal) || '2 - Two (0.00)';
        const isSweepAll = draft === (this.props.walletDetails.unlocked_balance / 1e9).toFixed(decimalValue.charAt(0));
        window.inboxStore?.dispatch((0, modalDialog_1.updateSendConfirmModal)(null));
        window.inboxStore?.dispatch((0, modalDialog_1.updateTransactionInitModal)({}));
        let transactionInitiatDetails = {
            message: {
                messageType: 'payment',
                props: {
                    id: this.props.selectedConversation?.id,
                    acceptUrl: '',
                    amount: this.state.draft,
                    direction: 'outgoing',
                    isUnread: false,
                    messageId: '1234-567-7890',
                    receivedAt: 1678799702674,
                    txnId: '',
                },
                showDateBreak: 1678799702809,
                showUnreadIndicator: false,
            },
        };
        window.inboxStore?.dispatch((0, walletConfig_2.updateWalletPaymentDetailsSend)(transactionInitiatDetails));
        let data = await wallet_rpc_1.wallet.transfer(this.props.selectedConversation?.walletAddress, draft * 1e9, priority === 'Flash' ? 0 : 1, isSweepAll);
        if (data.result) {
            const TransactionHistory = {
                tx_hash: data.result.tx_hash_list[0],
                address: this.props.selectedConversation?.walletAddress,
            };
            let getSettingvalue = window.getSettingValue(settings_key_1.walletSettingsKey.settingSaveRecipient);
            if (getSettingvalue) {
                await (0, data_1.saveRecipientAddress)(TransactionHistory);
            }
            window.inboxStore?.dispatch((0, modalDialog_1.updateSendConfirmModal)(null));
            window.inboxStore?.dispatch((0, modalDialog_1.updateTransactionInitModal)(null));
            utils_1.ToastUtils.pushToastSuccess('successfully-sended', `Your transaction was successful.`);
            let selectedConversationKey = this.props.selectedConversationKey;
            const privateConvo = await (0, conversations_1.getConversationController)().getOrCreateAndWait(selectedConversationKey, conversation_1.ConversationTypeEnum.PRIVATE);
            window.inboxStore?.dispatch((0, walletConfig_2.updateWalletPaymentDetailsSend)(null));
            if (privateConvo) {
                void privateConvo.sendMessage({
                    body: '',
                    attachments: undefined,
                    groupInvitation: undefined,
                    preview: undefined,
                    quote: undefined,
                    payment: {
                        amount: (data?.result?.amount_list[0] / 1e9).toString(),
                        txnId: TransactionHistory.tx_hash,
                    },
                });
                this.setState({
                    showEmojiPanel: false,
                    stagedLinkPreview: undefined,
                    ignoredLink: undefined,
                    draft: '',
                });
                (0, BchatConversationDrafts_1.updateDraftForConversation)({
                    conversationKey: selectedConversationKey,
                    draft: '',
                });
            }
        }
        else {
            window.inboxStore?.dispatch((0, modalDialog_1.updateSendConfirmModal)(null));
            window.inboxStore?.dispatch((0, modalDialog_1.updateTransactionInitModal)(null));
            return data;
        }
    };
    componentDidUpdate(prevProps, _prevState) {
        if (prevProps.selectedConversationKey !== this.props.selectedConversationKey) {
            this.setState(getDefaultState(this.props.selectedConversationKey), this.focusCompositionBox);
            this.lastBumpTypingMessageLength = 0;
        }
        else if (this.props.stagedAttachments?.length !== prevProps.stagedAttachments?.length) {
            this.focusCompositionBox();
        }
        if (!lodash_1.default.isEqual(prevProps.quotedMessageProps, this.props.quotedMessageProps)) {
            this.focusCompositionBox();
        }
    }
    render() {
        return (react_1.default.createElement(Flex_1.Flex, { flexDirection: "column" },
            react_1.default.createElement("div", { className: "composition-container" }, this.renderCompositionView())));
    }
    handleClick(e) {
        if ((this.emojiPanel?.current && this.emojiPanel.current.contains(e.target)) ||
            (this.emojiPanelButton?.current && this.emojiPanelButton.current.contains(e.target))) {
            return;
        }
        this.hideEmojiPanel();
    }
    handlePaste(e) {
        if (!e.clipboardData) {
            return;
        }
        const { items } = e.clipboardData;
        let imgBlob = null;
        for (const item of items) {
            const pasteType = item.type.split('/')[0];
            if (pasteType === 'image') {
                imgBlob = item.getAsFile();
            }
            switch (pasteType) {
                case 'image':
                    imgBlob = item.getAsFile();
                    break;
                case 'text':
                    void (0, conversationInteractions_1.showLinkSharingConfirmationModalDialog)(e);
                    break;
                default:
            }
        }
        if (imgBlob !== null) {
            const file = imgBlob;
            window?.log?.info('Adding attachment from clipboard', file);
            this.props.onChoseAttachments([file]);
            e.preventDefault();
            e.stopPropagation();
        }
    }
    showEmojiPanel() {
        document.addEventListener('mousedown', this.handleClick, false);
        this.setState({
            showEmojiPanel: true,
        });
    }
    hideEmojiPanel() {
        document.removeEventListener('mousedown', this.handleClick, false);
        this.setState({
            showEmojiPanel: false,
        });
    }
    toggleEmojiPanel() {
        if (this.state.showEmojiPanel) {
            this.hideEmojiPanel();
        }
        else {
            this.showEmojiPanel();
        }
    }
    percentageCalc() {
        const { walletHeight, deamonHeight } = this.props;
        let currentHeight = 0;
        let valdatedDaemonHeight = 0;
        const currentDaemon = window.getSettingValue(settings_key_1.walletSettingsKey.settingsCurrentDeamon);
        if (currentDaemon?.type === 'Local') {
            currentHeight = Number(deamonHeight);
            valdatedDaemonHeight = Number(walletHeight);
        }
        else {
            currentHeight = walletHeight;
            valdatedDaemonHeight = deamonHeight;
        }
        let pct = currentHeight == 0 || valdatedDaemonHeight == 0
            ? 0
            : ((100 * currentHeight) / valdatedDaemonHeight).toFixed(1);
        const percentage = pct == 100.0 && currentHeight < valdatedDaemonHeight ? 99.9 : pct;
        window.setSettingValue('syncStatus', percentage >= 99);
        return percentage;
    }
    renderRecordingView() {
        return (react_1.default.createElement(BchatRecording_1.BchatRecording, { sendVoiceMessage: this.sendVoiceMessage, onLoadVoiceNoteView: this.onLoadVoiceNoteView, onExitVoiceNoteView: this.onExitVoiceNoteView }));
    }
    bchatWalletView() {
        const { selectedConversation, WalletSyncBarShowInChat } = this.props;
        return (react_1.default.createElement(react_1.default.Fragment, null, selectedConversation?.type === 'private' &&
            selectedConversation?.isApproved &&
            selectedConversation?.didApproveMe &&
            !selectedConversation?.isBlocked &&
            this.chatwithWallet &&
            WalletSyncBarShowInChat ? (react_1.default.createElement(react_1.default.Fragment, null, this.renderCurcularBar())) : (react_1.default.createElement(CompositionButtons_1.SendFundDisableButton, { onClick: () => this.chatWithWalletInstruction() }))));
    }
    sendButton() {
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(CompositionButtons_1.SendMessageButton, { name: "Send", onClick: () => this.onSendMessage() })));
    }
    renderCurcularBar(ispopover) {
        const pathColor = this.percentageCalc() !== 0 ? '#108D32' : '#FDB12A';
        return (react_1.default.createElement(ChangingProgressProvider_1.default, { values: [0, 20, 40, 60, 80, 100] }, () => (react_1.default.createElement(react_circular_progressbar_1.CircularProgressbarWithChildren, { value: this.percentageCalc(), styles: {
                root: {
                    width: ispopover ? '47px' : '40px',
                },
                path: {
                    stroke: `${pathColor}`,
                    strokeLinecap: 'butt',
                    transition: 'stroke-dashoffset 0.5s ease 0s',
                    transformOrigin: 'center center',
                },
                trail: {
                    stroke: '#888A8D',
                    strokeLinecap: 'butt',
                    transform: 'rotate(0.25turn)',
                    transformOrigin: 'center center',
                },
            } }, ispopover ? (react_1.default.createElement("span", { className: "inner-perc-txt" },
            Math.floor(this.percentageCalc()),
            "%")) : (react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'beldexCoinLogo', iconSize: 20, iconColor: " #888A8D" }))))));
    }
    deleteContact() {
        const convoId = this.props.selectedConversationKey;
        window?.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)({
            title: window.i18n('editMenuDeleteContact'),
            message: 'Permanently delete the Contact?',
            onClickClose: () => window?.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)(null)),
            onClickOk: async () => {
                await (0, conversations_1.getConversationController)().deleteContact(convoId);
                utils_1.ToastUtils.pushToastSuccess('', 'Contact has been successfully deleted.');
            },
            okText: 'Delete',
            okTheme: BchatButton_1.BchatButtonColor.Danger,
        }));
    }
    renderBlockedContactBottoms() {
        const convoId = this.props.selectedConversationKey;
        return (react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "center", alignItems: "center", height: "90px" },
            react_1.default.createElement(BchatButton_1.BchatButton, { buttonType: BchatButton_1.BchatButtonType.Brand, buttonColor: BchatButton_1.BchatButtonColor.Danger, text: 'Delete this contact', onClick: () => this.deleteContact() }),
            react_1.default.createElement(Text_1.SpacerLG, null),
            react_1.default.createElement(BchatButton_1.BchatButton, { buttonType: BchatButton_1.BchatButtonType.Brand, buttonColor: BchatButton_1.BchatButtonColor.Primary, text: 'Unblock contact', onClick: () => {
                    this.setState(getDefaultState());
                    (0, conversationInteractions_1.unblockConvoById)(convoId);
                } })));
    }
    renderLeavedGroupBottoms() {
        return (react_1.default.createElement(Flex_1.Flex, { container: true, justifyContent: "center", alignItems: "center", height: "90px" },
            react_1.default.createElement("div", { className: "leaved-scrt-grp-message-container" }, "You can\u2019t send message to this group because you\u2019re not a member of this group!")));
    }
    renderCompositionView() {
        const { showEmojiPanel, selectionMenuIsVisble } = this.state;
        const { typingEnabled, stagedAttachments } = this.props;
        const { selectedConversation, isMe, WalletSyncBarShowInChat } = this.props;
        const { draft } = this.state;
        const syncStatus = this.percentageCalc() === 0
            ? 'Scanning..'
            : this.percentageCalc() > 0 && this.percentageCalc() < 98
                ? 'Syncronizing..'
                : 'Synchronized';
        const leftTheGroup = selectedConversation?.isGroup && selectedConversation?.left;
        return (react_1.default.createElement(react_1.default.Fragment, null, leftTheGroup ? (this.renderLeavedGroupBottoms()) : selectedConversation?.isBlocked ? (this.renderBlockedContactBottoms()) : (react_1.default.createElement(react_1.default.Fragment, null,
            typingEnabled && !this.state.showRecordingView && (react_1.default.createElement("div", { className: (0, classnames_1.default)(`attachment-wrapper ${selectionMenuIsVisble && 'seleted'}`) },
                selectionMenuIsVisble && (react_1.default.createElement("div", { className: "selection-box", onMouseLeave: () => this.setState({ selectionMenuIsVisble: false }) },
                    react_1.default.createElement(Flex_1.Flex, { container: true, padding: "15px", className: "content-Wrapper", alignItems: "center", onClick: this.onChooseAttachment },
                        react_1.default.createElement(MediaFileIcon_1.default, null),
                        react_1.default.createElement("span", null, "Media Files")),
                    react_1.default.createElement(Text_1.SpacerSM, null),
                    react_1.default.createElement(Flex_1.Flex, { container: true, padding: "15px", className: "content-Wrapper", alignItems: "center", onClick: this.onChooseContacts },
                        react_1.default.createElement(ContactsIcon_1.default, null),
                        react_1.default.createElement("span", null, "Contacts")))),
                react_1.default.createElement(CompositionButtons_1.AddStagedAttachmentButton, { onClick: () => this.setState({ selectionMenuIsVisble: true }) }))),
            react_1.default.createElement("input", { className: "hidden", placeholder: "Attachment", multiple: true, ref: this.fileInput, type: "file", onChange: this.onChoseAttachment }),
            this.state.showRecordingView && typingEnabled ? (this.renderRecordingView()) : (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement("div", { className: "send-message-input", role: "main", onClick: this.focusCompositionBox, ref: el => {
                        this.container = el;
                    }, "data-testid": "message-input" },
                    react_1.default.createElement(BchatQuotedMessageComposition_1.BchatQuotedMessageComposition, null),
                    this.renderStagedLinkPreview(),
                    this.renderAttachmentsStaged(),
                    react_1.default.createElement(Flex_1.Flex, { container: true, flexDirection: "row", width: "100%", alignItems: "center", style: { minHeight: '60px' }, padding: "10px 0" },
                        react_1.default.createElement("div", { className: "send-message-input__emoji-overlay" }, typingEnabled && (react_1.default.createElement(StyledEmojiPanelContainer, { ref: this.emojiPanel, onKeyDown: this.onKeyDown, role: "button" },
                            react_1.default.createElement(CompositionButtons_1.ToggleEmojiButton, { ref: this.emojiPanelButton, onClick: this.toggleEmojiPanel })))),
                        this.renderTextArea(),
                        react_1.default.createElement("div", { className: (0, classnames_1.default)(WalletSyncBarShowInChat &&
                                !this.sendAmountValidation() &&
                                'circular-bar-wrapper') }, selectedConversation?.isPrivate &&
                            typingEnabled &&
                            !isMe &&
                            selectedConversation?.didApproveMe &&
                            this.bchatWalletView()),
                        react_1.default.createElement("div", { className: "wallet-sync-box" },
                            react_1.default.createElement("div", { className: "sync-txt" },
                                "Wallet ",
                                react_1.default.createElement("span", null,
                                    " ",
                                    syncStatus)),
                            react_1.default.createElement("div", null, this.renderCurcularBar(true))),
                        this.sendAmountValidation() && (react_1.default.createElement("div", { className: "amount-tap-box", onClick: () => this.sendConfirmModal() },
                            react_1.default.createElement("div", { className: "sync-txt", style: { marginRight: 'unset' } },
                                "Tap to send ",
                                react_1.default.createElement(BeldexCoinLogo_1.default, { iconSize: 22 }),
                                " ",
                                react_1.default.createElement("span", null,
                                    " ",
                                    draft,
                                    " "),
                                "BDX",
                                ' ',
                                react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: "send", iconSize: 20, iconColor: "#0B9E3C" })))))),
                typingEnabled && (draft || stagedAttachments.length !== 0) ? (react_1.default.createElement("div", { className: (0, classnames_1.default)('send-message-button') }, this.sendButton())) : (react_1.default.createElement(CompositionButtons_1.StartRecordingButton, { onClick: this.onLoadVoiceNoteView })))),
            typingEnabled && (react_1.default.createElement("div", { ref: this.emojiPanel, onKeyDown: this.onKeyDown, role: "button" }, showEmojiPanel && (react_1.default.createElement(BchatEmojiPanel_1.BchatEmojiPanel, { onEmojiClicked: this.onEmojiClick, show: showEmojiPanel, ref: this.emojiPanel }))))))));
    }
    renderTextArea() {
        const { i18n } = window;
        const { draft } = this.state;
        if (!this.props.selectedConversation) {
            return null;
        }
        const makeMessagePlaceHolderText = () => {
            if (isKickedFromGroup) {
                return i18n('youGotKickedFromGroup');
            }
            if (left) {
                return i18n('youLeftTheGroup');
            }
            if (isBlocked && isPrivate) {
                return i18n('unblockToSend');
            }
            if (isBlocked && !isPrivate) {
                return i18n('unblockGroupToSend');
            }
            return i18n('sendMessage');
        };
        const { isKickedFromGroup, left, isPrivate, isBlocked } = this.props.selectedConversation;
        const messagePlaceHolder = makeMessagePlaceHolderText();
        const { typingEnabled } = this.props;
        const neverMatchingRegex = /($a)/;
        return (react_1.default.createElement(react_mentions_1.MentionsInput, { value: draft, onChange: this.onChange, onKeyDown: this.onKeyDown, onKeyUp: this.onKeyUp, placeholder: messagePlaceHolder, spellCheck: true, inputRef: this.textarea, disabled: !typingEnabled, rows: 1, "data-testid": "message-input-text-area", style: sendMessageStyle, suggestionsPortalHost: this.container, forceSuggestionsAboveCursor: true },
            react_1.default.createElement(react_mentions_1.Mention, { appendSpaceOnAdd: true, markup: "@\uFFD2__id__\uFFD7__display__\uFFD2", trigger: "@", displayTransform: (_id, display) => `@${display}`, data: this.fetchUsersForGroup, renderSuggestion: UserMentions_1.renderUserMentionRow }),
            react_1.default.createElement(react_mentions_1.Mention, { trigger: ":", markup: "__id__", appendSpaceOnAdd: true, regex: neverMatchingRegex, data: EmojiQuickResult_1.searchEmojiForQuery, renderSuggestion: EmojiQuickResult_1.renderEmojiQuickResultRow })));
    }
    fetchUsersForOpenGroup(query, callback) {
        const mentionsInput = (0, conversations_3.getMentionsInput)(window?.inboxStore?.getState() || []);
        const filtered = mentionsInput
            .filter(d => !!d)
            .filter(d => d.authorProfileName !== 'Anonymous')
            .filter(d => d.authorProfileName?.toLowerCase()?.includes(query.toLowerCase()))
            .map(user => {
            return {
                display: user.authorProfileName,
                id: user.id,
            };
        }) || [];
        callback(filtered);
    }
    fetchUsersForGroup(query, callback) {
        let overridenQuery = query;
        if (!query) {
            overridenQuery = '';
        }
        if (!this.props.selectedConversation) {
            return;
        }
        if (this.props.selectedConversation.isPublic) {
            this.fetchUsersForOpenGroup(overridenQuery, callback);
            return;
        }
        if (!this.props.selectedConversation.isPrivate) {
            this.fetchUsersForClosedGroup(overridenQuery, callback);
            return;
        }
    }
    fetchUsersForClosedGroup(query, callback) {
        const { selectedConversation } = this.props;
        if (!selectedConversation) {
            return;
        }
        const allPubKeys = selectedConversation.members;
        if (!allPubKeys || allPubKeys.length === 0) {
            return;
        }
        const allMembers = allPubKeys.map(pubKey => {
            const conv = (0, conversations_1.getConversationController)().get(pubKey);
            let profileName = 'Anonymous';
            if (conv) {
                profileName = conv.getProfileName() || 'Anonymous';
            }
            return {
                id: pubKey,
                authorProfileName: profileName,
            };
        });
        const members = allMembers
            .filter(d => !!d)
            .filter(d => d.authorProfileName?.toLowerCase()?.includes(query.toLowerCase()) || !d.authorProfileName);
        const mentionsData = members.map(user => ({
            display: user.authorProfileName || window.i18n('anonymous'),
            id: user.id,
        }));
        callback(mentionsData);
    }
    renderStagedLinkPreview() {
        if (!(window.getSettingValue('link-preview-setting') || false)) {
            return null;
        }
        const { stagedAttachments, quotedMessageProps } = this.props;
        const { ignoredLink } = this.state;
        if (stagedAttachments.length !== 0 || quotedMessageProps?.id) {
            return null;
        }
        const links = linkPreviews_1.LinkPreviews.findLinks(this.state.draft, undefined);
        if (!links || links.length === 0 || ignoredLink === links[0]) {
            if (this.state.stagedLinkPreview) {
                this.setState({
                    stagedLinkPreview: undefined,
                });
            }
            return null;
        }
        const firstLink = links[0];
        if (ignoredLink && ignoredLink !== firstLink) {
            this.setState({ ignoredLink: undefined });
        }
        if (firstLink !== this.state.stagedLinkPreview?.url) {
            this.fetchLinkPreview(firstLink);
        }
        if (!this.state.stagedLinkPreview) {
            return null;
        }
        const { isLoaded, title, domain, image } = this.state.stagedLinkPreview;
        return (react_1.default.createElement(BchatStagedLinkPreview_1.BchatStagedLinkPreview, { isLoaded: isLoaded, title: title, domain: domain, image: image, url: firstLink, onClose: url => {
                this.setState({ ignoredLink: url });
            } }));
    }
    fetchLinkPreview(firstLink) {
        this.setState({
            stagedLinkPreview: {
                isLoaded: false,
                url: firstLink,
                domain: null,
                image: undefined,
                title: null,
            },
        });
        const abortController = new abort_controller_1.AbortController();
        this.linkPreviewAbortController?.abort();
        this.linkPreviewAbortController = abortController;
        setTimeout(() => {
            abortController.abort();
        }, BchatStagedLinkPreview_1.LINK_PREVIEW_TIMEOUT);
        (0, BchatStagedLinkPreview_1.getPreview)(firstLink, abortController.signal)
            .then(ret => {
            if (this.linkPreviewAbortController && !this.linkPreviewAbortController.signal.aborted) {
                this.setState({
                    stagedLinkPreview: {
                        isLoaded: true,
                        title: ret?.title || null,
                        url: ret?.url || null,
                        domain: (ret?.url && linkPreviews_1.LinkPreviews.getDomain(ret.url)) || '',
                        image: ret?.image,
                    },
                });
            }
            else if (this.linkPreviewAbortController) {
                this.setState({
                    stagedLinkPreview: {
                        isLoaded: false,
                        title: null,
                        url: null,
                        domain: null,
                        image: undefined,
                    },
                });
                this.linkPreviewAbortController = undefined;
            }
        })
            .catch(err => {
            window?.log?.warn('fetch link preview: ', err);
            const aborted = this.linkPreviewAbortController?.signal.aborted;
            this.linkPreviewAbortController = undefined;
            if (aborted) {
                this.setState({
                    stagedLinkPreview: undefined,
                });
            }
            else {
                this.setState({
                    stagedLinkPreview: {
                        isLoaded: true,
                        title: null,
                        url: firstLink,
                        domain: null,
                        image: undefined,
                    },
                });
            }
        });
    }
    onClickAttachment(attachment) {
        this.setState({ showCaptionEditor: attachment });
    }
    renderCaptionEditor(attachment) {
        if (attachment) {
            const onSave = (caption) => {
                attachment.caption = caption;
                utils_1.ToastUtils.pushToastInfo('saved', window.i18n('saved'));
                this.setState({
                    showCaptionEditor: undefined,
                });
            };
            const url = attachment.videoUrl || attachment.url;
            return (react_1.default.createElement(CaptionEditor_1.CaptionEditor, { attachment: attachment, url: url, onSave: onSave, caption: attachment.caption, onClose: () => {
                    this.setState({
                        showCaptionEditor: undefined,
                    });
                } }));
        }
        return null;
    }
    renderAttachmentsStaged() {
        const { stagedAttachments } = this.props;
        const { showCaptionEditor } = this.state;
        if (stagedAttachments && stagedAttachments.length) {
            return (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(StagedAttachmentList_1.StagedAttachmentList, { attachments: stagedAttachments, onClickAttachment: this.onClickAttachment, onAddAttachment: this.onChooseAttachment }),
                this.renderCaptionEditor(showCaptionEditor)));
        }
        return null;
    }
    onChooseAttachment() {
        if (!this.props.selectedConversation?.didApproveMe &&
            this.props.selectedConversation?.isPrivate) {
            utils_1.ToastUtils.pushNoMediaUntilApproved();
            return;
        }
        this.setState({ selectionMenuIsVisble: false });
        window.inboxStore?.dispatch((0, conversations_2.closeShareContact)());
        this.fileInput.current?.click();
    }
    onChooseContacts() {
        if (!this.props.selectedConversation?.didApproveMe &&
            this.props.selectedConversation?.isPrivate) {
            utils_1.ToastUtils.pushNoContactUntilApproved();
            return;
        }
        window.inboxStore?.dispatch((0, conversations_2.closeRightPanel)());
        window.inboxStore?.dispatch((0, conversations_2.openShareContact)());
    }
    async onChoseAttachment() {
        let attachmentsFileList = null;
        if (this.fileInput.current?.files) {
            attachmentsFileList = Array.from(this.fileInput.current.files);
            this.fileInput.current.files = null;
            this.fileInput.current.value = '';
        }
        if (!attachmentsFileList || attachmentsFileList.length === 0) {
            return;
        }
        this.props.onChoseAttachments(attachmentsFileList);
    }
    async onKeyDown(event) {
        if (event.key === 'Enter' && !event.shiftKey && !event.nativeEvent.isComposing) {
            event.preventDefault();
            const { selectedConversation, WalletSyncBarShowInChat, isMe, BchatAlertConfirmModal, } = this.props;
            const getSyncStatus = window.getSettingValue('syncStatus');
            const { draft } = this.state;
            const re = /^\d+\.?\d*$/;
            if (selectedConversation?.type === 'private' &&
                re.test(draft) &&
                this.chatwithWallet &&
                selectedConversation?.isApproved &&
                selectedConversation?.didApproveMe &&
                WalletSyncBarShowInChat &&
                !isMe &&
                getSyncStatus) {
                await this.sendConfirmModal();
            }
            else {
                if (!BchatAlertConfirmModal) {
                    await this.onSendMessage();
                }
            }
        }
        else if (event.key === 'Escape' && this.state.showEmojiPanel) {
            this.hideEmojiPanel();
        }
        else if (event.key === 'PageUp' || event.key === 'PageDown') {
            event.preventDefault();
            event.stopPropagation();
        }
    }
    async onKeyUp() {
        if (!this.props.selectedConversationKey) {
            throw new Error('selectedConversationKey is needed');
        }
        const { draft } = this.state;
        if (draft && draft.length && draft.length !== this.lastBumpTypingMessageLength) {
            const conversationModel = (0, conversations_1.getConversationController)().get(this.props.selectedConversationKey);
            if (!conversationModel) {
                return;
            }
            conversationModel.throttledBumpTyping();
            this.lastBumpTypingMessageLength = draft.length;
        }
    }
    async onSendMessage() {
        if (!this.props.selectedConversationKey) {
            throw new Error('selectedConversationKey is needed');
        }
        this.linkPreviewAbortController?.abort();
        const messagePlaintext = (0, UserMentions_1.cleanMentions)(this.state.draft);
        const { selectedConversation } = this.props;
        if (!selectedConversation) {
            return;
        }
        if (selectedConversation.isBlocked && selectedConversation.isPrivate) {
            utils_1.ToastUtils.pushUnblockToSend();
            return;
        }
        if (selectedConversation.isBlocked && !selectedConversation.isPrivate) {
            utils_1.ToastUtils.pushUnblockToSendGroup();
            return;
        }
        const msgLen = messagePlaintext.trim().length || 0;
        if (msgLen === 0 && this.props.stagedAttachments?.length === 0) {
            utils_1.ToastUtils.pushMessageBodyMissing();
            return;
        }
        if (!selectedConversation.isPrivate && selectedConversation.left) {
            utils_1.ToastUtils.pushYouLeftTheGroup();
            return;
        }
        if (!selectedConversation.isPrivate && selectedConversation.isKickedFromGroup) {
            utils_1.ToastUtils.pushYouLeftTheGroup();
            return;
        }
        const { quotedMessageProps } = this.props;
        const { stagedLinkPreview } = this.state;
        const extractedQuotedMessageProps = lodash_1.default.pick(quotedMessageProps, 'id', 'author', 'text', 'attachments', 'direction');
        const linkPreview = stagedLinkPreview?.isLoaded && stagedLinkPreview.title?.length
            ? lodash_1.default.pick(stagedLinkPreview, 'url', 'image', 'title')
            : undefined;
        try {
            const { attachments, previews } = await this.getFiles(linkPreview);
            this.props.sendMessage({
                body: messagePlaintext.trim(),
                attachments: attachments || [],
                quote: extractedQuotedMessageProps,
                preview: previews,
                groupInvitation: undefined,
            });
            window.inboxStore?.dispatch((0, stagedAttachments_1.removeAllStagedAttachmentsInConversation)({
                conversationKey: this.props.selectedConversationKey,
            }));
            this.setState({
                showEmojiPanel: false,
                stagedLinkPreview: undefined,
                ignoredLink: undefined,
                draft: '',
            });
            (0, BchatConversationDrafts_1.updateDraftForConversation)({
                conversationKey: this.props.selectedConversationKey,
                draft: '',
            });
        }
        catch (e) {
            window?.log?.error(e);
        }
    }
    async getFiles(linkPreview) {
        const { stagedAttachments } = this.props;
        let attachments = [];
        let previews = [];
        if (lodash_1.default.isEmpty(stagedAttachments)) {
            attachments = [];
        }
        else {
            const files = await Promise.all(stagedAttachments.map(util_1.AttachmentUtil.getFileAndStoreLocally));
            attachments = lodash_1.default.compact(files);
        }
        if (!linkPreview || lodash_1.default.isEmpty(linkPreview) || !linkPreview.url || !linkPreview.title) {
            previews = [];
        }
        else {
            const sharedDetails = { url: linkPreview.url, title: linkPreview.title };
            const firstLinkPreviewImage = linkPreview.image;
            if (firstLinkPreviewImage && !(0, lodash_1.isEmpty)(firstLinkPreviewImage)) {
                const storedLinkPreviewAttachment = await util_1.AttachmentUtil.getFileAndStoreLocallyImageBuffer(firstLinkPreviewImage.data);
                if (storedLinkPreviewAttachment) {
                    previews = [{ ...sharedDetails, image: storedLinkPreviewAttachment }];
                }
                else {
                    previews = [sharedDetails];
                }
            }
            else {
                previews = [sharedDetails];
            }
        }
        return { attachments, previews };
    }
    async sendVoiceMessage(audioBlob) {
        if (!this.state.showRecordingView) {
            return;
        }
        const { selectedConversation } = this.props;
        if (selectedConversation?.isBlocked && selectedConversation?.isPrivate) {
            utils_1.ToastUtils.pushUnblockToSend();
            return;
        }
        if (selectedConversation?.isBlocked && !selectedConversation?.isPrivate) {
            utils_1.ToastUtils.pushUnblockToSendGroup();
            return;
        }
        const savedAudioFile = await (0, MessageAttachment_1.processNewAttachment)({
            data: await audioBlob.arrayBuffer(),
            isRaw: true,
            contentType: MIME.AUDIO_MP3,
        });
        const audioAttachment = {
            file: new File([], 'bchat-audio-message'),
            contentType: MIME.AUDIO_MP3,
            size: savedAudioFile.size,
            fileSize: null,
            screenshot: null,
            fileName: 'bchat-audio-message',
            thumbnail: null,
            url: '',
            isVoiceMessage: true,
            path: savedAudioFile.path,
        };
        const { quotedMessageProps } = this.props;
        const extractedQuotedMessageProps = lodash_1.default.pick(quotedMessageProps, 'id', 'author', 'text', 'attachments', 'direction');
        this.props.sendMessage({
            body: '',
            attachments: [audioAttachment],
            preview: undefined,
            quote: extractedQuotedMessageProps,
            groupInvitation: undefined,
        });
        this.onExitVoiceNoteView();
    }
    async onLoadVoiceNoteView() {
        if (!(0, BchatSettings_1.getMediaPermissionsSettings)()) {
            window.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)({
                title: window.i18n('audioPermissionNeededTitle'),
                message: window.i18n('audioPermissionNeeded'),
                okText: window.i18n('allow'),
                cancelText: window.i18n('deny'),
                okTheme: BchatButton_1.BchatButtonColor.Primary,
                onClickOk: async () => {
                    await window.toggleMediaPermissions();
                    window.inboxStore?.dispatch((0, modalDialog_1.updateConfirmModal)(null));
                },
                closeAfterInput: false,
                iconShow: true,
                customIcon: (react_1.default.createElement(BchatIcon_1.BchatIcon, { iconType: 'microphone', iconSize: 30, iconColor: "var(--color-icon)", fillRule: "evenodd", clipRule: "evenodd" })),
            }));
            return;
        }
        this.setState({
            showRecordingView: true,
            showEmojiPanel: false,
        });
        window.inboxStore?.dispatch((0, userConfig_1.updateIsCurrentlyRecording)(true));
    }
    onExitVoiceNoteView() {
        this.setState({ showRecordingView: false });
    }
    onChange(event) {
        if (!this.props.selectedConversationKey) {
            throw new Error('selectedConversationKey is needed');
        }
        const draft = event.target.value ?? '';
        this.setState({ draft });
        (0, BchatConversationDrafts_1.updateDraftForConversation)({ conversationKey: this.props.selectedConversationKey, draft });
    }
    onEmojiClick(emoji) {
        if (!this.props.selectedConversationKey) {
            throw new Error('selectedConversationKey is needed');
        }
        const messageBox = this.textarea.current;
        if (!messageBox) {
            return;
        }
        const { draft } = this.state;
        const currentSelectionStart = Number(messageBox.selectionStart);
        const realSelectionStart = getSelectionBasedOnMentions(draft, currentSelectionStart);
        const before = draft.slice(0, realSelectionStart);
        const end = draft.slice(realSelectionStart);
        const newMessage = `${before}${emoji.native}${end}`;
        this.setState({ draft: newMessage }, () => {
            setTimeout(() => {
                const emojiLength = emoji.native?.length || 0;
                messageBox.selectionStart = messageBox.selectionEnd = before.length + emojiLength;
                messageBox.focus();
            }, 0);
        });
        (0, BchatConversationDrafts_1.updateDraftForConversation)({
            conversationKey: this.props.selectedConversationKey,
            draft: newMessage,
        });
    }
    focusCompositionBox() {
        this.textarea.current?.focus();
    }
}
const mapStateToProps = (state) => {
    return {
        quotedMessageProps: (0, conversations_3.getQuotedMessage)(state),
        selectedConversation: (0, conversations_3.getSelectedConversation)(state),
        selectedConversationKey: (0, conversations_3.getSelectedConversationKey)(state),
        typingEnabled: (0, conversations_3.getIsTypingEnabled)(state),
        isMe: (0, conversations_3.getIsSelectedNoteToSelf)(state),
        WalletSyncBarShowInChat: (0, walletConfig_1.getWalletSyncBarShowInChat)(state),
        walletSyncStatus: (0, walletConfig_1.getRescaning)(state),
        walletDetails: state.wallet,
        BchatAlertConfirmModal: (0, modal_1.getBchatAlertConfirmModal)(state),
        deamonHeight: (0, daemon_1.getdaemonHeight)(state),
        walletHeight: (0, walletConfig_1.getHeight)(state),
    };
};
const smart = (0, react_redux_1.connect)(mapStateToProps);
exports.CompositionBox = smart(CompositionBoxInner);
