"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.searchEmojiForQuery = exports.renderEmojiQuickResultRow = void 0;
const react_1 = __importDefault(require("react"));
const styled_components_1 = __importDefault(require("styled-components"));
const emoji_js_1 = require("../../../util/emoji.js");
const emoji_mart_1 = require("emoji-mart");
const EmojiQuickResult = styled_components_1.default.span `
  width: 100%;
  padding-inline-end: 20px;
  padding-inline-start: 10px;
`;
const EmojiQuickResultIcon = styled_components_1.default.span `
  padding-inline-end: 20px;
  padding-inline-start: 10px;
  font-size: 1.4em;
`;
const EmojiQuickResultText = styled_components_1.default.span ``;
const renderEmojiQuickResultRow = (suggestion) => {
    return (react_1.default.createElement(EmojiQuickResult, null,
        react_1.default.createElement(EmojiQuickResultIcon, null, suggestion.id),
        react_1.default.createElement(EmojiQuickResultText, null, suggestion.display)));
};
exports.renderEmojiQuickResultRow = renderEmojiQuickResultRow;
const searchEmojiForQuery = (query) => {
    if (query.length === 0 || !emoji_mart_1.SearchIndex) {
        return [];
    }
    const results1 = (0, emoji_js_1.searchSync)(`:${query}`);
    const results2 = (0, emoji_js_1.searchSync)(query);
    const results = [...new Set(results1.concat(results2))];
    if (!results || !results.length) {
        return [];
    }
    const cleanResults = results
        .map((emoji) => {
        return {
            id: emoji.skins[0].native,
            display: `:${emoji.id}:`,
        };
    })
        .slice(0, 8);
    return cleanResults;
};
exports.searchEmojiForQuery = searchEmojiForQuery;
