"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mentionsRegex = exports.cleanMentions = exports.renderUserMentionRow = exports.styleForCompositionBoxSuggestions = void 0;
const react_1 = __importDefault(require("react"));
const MemberListItem_1 = require("../../MemberListItem");
exports.styleForCompositionBoxSuggestions = {
    suggestions: {
        list: {
            fontSize: 14,
            boxShadow: 'rgba(0, 0, 0, 0.24) 0px 3px 8px',
            backgroundColor: 'var(--color-cell-background)',
        },
        item: {
            height: '100%',
            paddingTop: '5px',
            paddingBottom: '5px',
            backgroundColor: 'var(--color-cell-background)',
            transition: '0.25s',
            '&focused': {
                backgroundColor: 'var(--color-clickable-hovered)',
            },
        },
    },
};
const renderUserMentionRow = (suggestion) => {
    return (react_1.default.createElement(MemberListItem_1.MemberListItem, { isSelected: false, key: suggestion.id, pubkey: `${suggestion.id}`, disableBg: true, dataTestId: "mentions-popup-row" }));
};
exports.renderUserMentionRow = renderUserMentionRow;
function cleanMentions(text) {
    return text.replace(/@ￒ(.*?)ￗ.*?ￒ/g, '@$1');
}
exports.cleanMentions = cleanMentions;
exports.mentionsRegex = /@ￒ(.*?)ￗ.*?ￒ/g;
