"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DocumentListItem = void 0;
const react_1 = __importStar(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const moment_1 = __importDefault(require("moment"));
const filesize_1 = __importDefault(require("filesize"));
const react_redux_1 = require("react-redux");
const conversations_1 = require("../../../state/selectors/conversations");
const attachmentsUtil_1 = require("../../../util/attachmentsUtil");
const DocumentListItem = (props) => {
    const { shouldShowSeparator, fileName, fileSize, timestamp } = props;
    const defaultShowSeparator = shouldShowSeparator === undefined ? true : shouldShowSeparator;
    const selectedConversationKey = (0, react_redux_1.useSelector)(conversations_1.getSelectedConversationKey);
    const saveAttachmentCallback = (0, react_1.useCallback)(() => {
        void (0, attachmentsUtil_1.saveAttachmentToDisk)({
            messageSender: props.mediaItem.messageSender,
            messageTimestamp: props.mediaItem.messageTimestamp,
            attachment: props.mediaItem.attachment,
            conversationId: selectedConversationKey,
        });
    }, [
        selectedConversationKey,
        props.mediaItem.messageSender,
        props.mediaItem.messageTimestamp,
        props.mediaItem.attachment,
    ]);
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)('module-document-list-item', defaultShowSeparator ? 'module-document-list-item--with-separator' : null) },
        react_1.default.createElement("div", { className: "module-document-list-item__content", role: "button", onClick: saveAttachmentCallback },
            react_1.default.createElement("div", { className: "module-document-list-item__icon" }),
            react_1.default.createElement("div", { className: "module-document-list-item__metadata" },
                react_1.default.createElement("span", { className: "module-document-list-item__file-name" }, fileName),
                react_1.default.createElement("span", { className: "module-document-list-item__file-size" }, typeof fileSize === 'number' ? (0, filesize_1.default)(fileSize) : '')),
            react_1.default.createElement("div", { className: "module-document-list-item__date" }, (0, moment_1.default)(timestamp).format('ddd, MMM D, Y')))));
};
exports.DocumentListItem = DocumentListItem;
