"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaGallery = void 0;
const react_1 = __importStar(require("react"));
const classnames_1 = __importDefault(require("classnames"));
const AttachmentSection_1 = require("./AttachmentSection");
const EmptyState_1 = require("./EmptyState");
const Text_1 = require("../../basic/Text");
const Tab = ({ isSelected, label, onSelect, }) => {
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)('module-media-gallery__tab', isSelected ? 'module-media-gallery__tab--active' : null), onClick: onSelect, role: "tab" }, label));
};
const Sections = (props) => {
    const { media, documents, selectedTab } = props;
    const mediaItems = selectedTab === 'media' ? media : documents;
    const type = selectedTab;
    if (!mediaItems || mediaItems.length === 0) {
        const label = type === 'media' ? window.i18n('mediaEmptyState') : window.i18n('documentsEmptyState');
        return react_1.default.createElement(EmptyState_1.EmptyState, { "data-testid": "EmptyState", label: label });
    }
    return (react_1.default.createElement("div", { className: "module-media-gallery__sections" },
        react_1.default.createElement(AttachmentSection_1.AttachmentSection, { key: "mediaItems", type: type, mediaItems: mediaItems })));
};
const MediaGallery = (props) => {
    const [selectedTab, setSelectedTab] = (0, react_1.useState)('media');
    const { fullView } = props;
    const isDocumentSelected = selectedTab === 'documents';
    const isMediaSelected = selectedTab === 'media';
    const setMediaTab = (0, react_1.useCallback)(() => {
        setSelectedTab('media');
    }, []);
    const setDocumentsTab = (0, react_1.useCallback)(() => {
        setSelectedTab('documents');
    }, []);
    return (react_1.default.createElement("div", { className: "module-media-gallery" },
        fullView && (react_1.default.createElement("div", { className: "module-media-gallery__tab-container" },
            react_1.default.createElement(Tab, { label: window.i18n('media'), isSelected: isMediaSelected, onSelect: setMediaTab }),
            react_1.default.createElement(Tab, { label: window.i18n('documents'), isSelected: isDocumentSelected, onSelect: setDocumentsTab }),
            react_1.default.createElement(Text_1.SpacerMD, null))),
        react_1.default.createElement("div", { className: "module-media-gallery__content" },
            react_1.default.createElement(Sections, { ...props, selectedTab: selectedTab }))));
};
exports.MediaGallery = MediaGallery;
