"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageAuthorText = void 0;
const react_1 = __importDefault(require("react"));
const react_redux_1 = require("react-redux");
const types_1 = require("../../../../bchat/types");
const conversations_1 = require("../../../../state/selectors/conversations");
const Flex_1 = require("../../../basic/Flex");
const ContactName_1 = require("../../ContactName");
const AvatarPlaceHolder_1 = require("../../../avatar/AvatarPlaceHolder/AvatarPlaceHolder");
const AvatarPlaceHolder_2 = require("../../../avatar/AvatarPlaceHolder/AvatarPlaceHolder");
const MessageAuthorText = (props) => {
    const selected = (0, react_redux_1.useSelector)(state => (0, conversations_1.getMessageAuthorProps)(state, props.messageId));
    const isPublic = (0, react_redux_1.useSelector)(conversations_1.isPublicGroupConversation);
    const isGroup = (0, react_redux_1.useSelector)(conversations_1.isGroupConversation);
    if (!selected) {
        return null;
    }
    const { authorName, sender, authorProfileName, direction, firstMessageOfSeries } = selected;
    const title = authorName ? authorName : sender;
    if (direction !== 'incoming' || !isGroup || !title || !firstMessageOfSeries) {
        return null;
    }
    const shortenedPubkey = types_1.PubKey.shorten(sender);
    const displayedPubkey = authorProfileName ? shortenedPubkey : sender;
    const bgColorIndex = (AvatarPlaceHolder_1.cachedHashes.get(sender) ?? 0) % AvatarPlaceHolder_2.avatarPlaceholderColors.length;
    const avatarColors = AvatarPlaceHolder_2.avatarPlaceholderColors[bgColorIndex];
    return (react_1.default.createElement(Flex_1.Flex, { container: true, className: 'module-message_grp_author_wrapper', style: { color: avatarColors?.bgColor || 'var(--color-text)', textTransform: 'capitalize' } },
        react_1.default.createElement(ContactName_1.ContactName, { pubkey: displayedPubkey, name: authorName, profileName: authorProfileName, module: "module-message__author", boldProfileName: true, shouldShowPubkey: Boolean(isPublic) })));
};
exports.MessageAuthorText = MessageAuthorText;
