"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessageAvatar = void 0;
const react_1 = __importStar(require("react"));
const react_redux_1 = require("react-redux");
const modalDialog_1 = require("../../../../state/ducks/modalDialog");
const conversations_1 = require("../../../../state/selectors/conversations");
const Avatar_1 = require("../../../avatar/Avatar");
const styled_components_1 = __importDefault(require("styled-components"));
const useParamSelector_1 = require("../../../../hooks/useParamSelector");
const lodash_1 = require("lodash");
const StyledAvatarWrapper = styled_components_1.default.div `
  display: flex;
  align-self: flex-end;
  margin-bottom:${(props) => props.enableReactions ? '52px' : '16px'};
`;
const MessageAvatar = (props) => {
    const { messageId } = props;
    const dispatch = (0, react_redux_1.useDispatch)();
    const avatarProps = (0, react_redux_1.useSelector)(state => (0, conversations_1.getMessageAvatarProps)(state, messageId));
    const msgProps = (0, useParamSelector_1.useMessageReactsPropsById)(messageId);
    const reacts = !(0, lodash_1.isEmpty)(msgProps?.reacts);
    if (!avatarProps) {
        return null;
    }
    const { authorAvatarPath, authorName, sender, authorProfileName, conversationType, direction, isPublic, isSenderAdmin, lastMessageOfSeries, } = avatarProps;
    if (conversationType !== 'group' || direction === 'outgoing') {
        return null;
    }
    const userName = authorName || authorProfileName || sender;
    const onMessageAvatarClick = (0, react_1.useCallback)(() => {
        dispatch((0, modalDialog_1.updateUserDetailsModal)({
            conversationId: sender,
            userName,
            authorAvatarPath,
        }));
    }, [userName, sender, authorAvatarPath]);
    if (!lastMessageOfSeries) {
        return react_1.default.createElement("div", { style: { marginInlineEnd: '63px' }, key: `msg-avatar-${sender}` });
    }
    return (react_1.default.createElement(StyledAvatarWrapper, { enableReactions: reacts },
        react_1.default.createElement("div", { className: "module-message__author-avatar", key: `msg-avatar-${sender}` },
            react_1.default.createElement(Avatar_1.Avatar, { size: Avatar_1.AvatarSize.M, onAvatarClick: (!isPublic && onMessageAvatarClick) || undefined, pubkey: sender }),
            isSenderAdmin && react_1.default.createElement(Avatar_1.CrownIcon, null))));
};
exports.MessageAvatar = MessageAvatar;
