"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessagePreview = void 0;
const classnames_1 = __importDefault(require("classnames"));
const react_1 = __importDefault(require("react"));
const Attachment_1 = require("../../../../types/Attachment");
const Image_1 = require("../../Image");
const react_redux_1 = require("react-redux");
const conversations_1 = require("../../../../state/selectors/conversations");
const icon_1 = require("../../../icon");
const Message_1 = require("../message-item/Message");
const MessagePreview = (props) => {
    const selected = (0, react_redux_1.useSelector)(state => (0, conversations_1.getMessagePreviewProps)(state, props.messageId));
    if (!selected) {
        return null;
    }
    const { attachments, previews } = selected;
    if (attachments && attachments.length) {
        return null;
    }
    if (!previews || previews.length < 1) {
        return null;
    }
    const first = previews[0];
    if (!first) {
        return null;
    }
    const previewHasImage = first.image && (0, Attachment_1.isImageAttachment)(first.image);
    const width = first.image && first.image.width;
    const isFullSizeImage = width && width >= Message_1.MINIMUM_LINK_PREVIEW_IMAGE_WIDTH;
    return (react_1.default.createElement("div", { role: "button", className: (0, classnames_1.default)('module-message__link-preview') },
        first.image && previewHasImage && isFullSizeImage ? (react_1.default.createElement(Image_1.Image, { softCorners: true, alt: window.i18n('previewThumbnail', [first.domain]), height: 68, width: 68, url: first.image.url, attachment: first.image, onError: props.handleImageError })) :
            react_1.default.createElement("div", { className: (0, classnames_1.default)('noImage', `noImage__${props.direction}`) },
                react_1.default.createElement(icon_1.BchatIcon, { iconType: "openLink", iconSize: "medium" })),
        react_1.default.createElement("div", { className: (0, classnames_1.default)('module-message__link-preview__content', `module-message__link-preview__content__${props.direction}`) },
            first.image && previewHasImage && !isFullSizeImage ? (react_1.default.createElement("div", { className: "module-message__link-preview__image_container" },
                react_1.default.createElement(Image_1.Image, { softCorners: true, alt: window.i18n('previewThumbnail', [first.domain]), height: 72, width: 72, url: first.image.url, attachment: first.image, onError: props.handleImageError }))) : !first.image || !previewHasImage ? (react_1.default.createElement("div", { className: "module-message__link-preview__icon_container" },
                react_1.default.createElement("div", { className: "module-message__link-preview__icon_container__inner" }))) : null,
            react_1.default.createElement("div", { className: (0, classnames_1.default)('module-message__link-preview__text', previewHasImage && !isFullSizeImage
                    ? 'module-message__link-preview__text--with-icon'
                    : null) },
                react_1.default.createElement("div", { className: (0, classnames_1.default)('module-message__link-preview__title', `${props.direction}`) }, first.title),
                react_1.default.createElement("div", { className: (0, classnames_1.default)('module-message__link-preview__location', `${props.direction}`) }, first.domain)))));
};
exports.MessagePreview = MessagePreview;
